/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.netflix.ribbon.runtime;

import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.AbstractServerList;
import com.netflix.loadbalancer.Server;
import java.util.List;
import java.util.stream.Collectors;
import org.wildfly.swarm.topology.runtime.TopologyManager;

public class TopologyServerList
extends AbstractServerList<Server> {
    private String appName;
    private Boolean isSecure;

    public void initWithNiwsConfig(IClientConfig config) {
        this.appName = config.getClientName();
        this.isSecure = (Boolean)config.get(IClientConfigKey.Keys.IsSecure, (Object)false);
    }

    public List<Server> getInitialListOfServers() {
        String tag = this.isSecure != false ? "https" : "http";
        return TopologyManager.INSTANCE.registrationsForService(this.appName, tag).stream().map(reg -> new Server(reg.getAddress(), reg.getPort())).collect(Collectors.toList());
    }

    public List<Server> getUpdatedListOfServers() {
        String tag = this.isSecure != false ? "https" : "http";
        return TopologyManager.INSTANCE.registrationsForService(this.appName, tag).stream().map(reg -> new Server(reg.getAddress(), reg.getPort())).collect(Collectors.toList());
    }
}

