/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.security;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.wildfly.swarm.config.Security;
import org.wildfly.swarm.config.security.Flag;
import org.wildfly.swarm.config.security.SecurityDomain;
import org.wildfly.swarm.config.security.security_domain.ClassicAuthentication;
import org.wildfly.swarm.config.security.security_domain.JaspiAuthentication;
import org.wildfly.swarm.config.security.security_domain.authentication.AuthModule;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModule;
import org.wildfly.swarm.config.security.security_domain.authentication.LoginModuleStack;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.annotations.MarshalDMR;
import org.wildfly.swarm.spi.api.annotations.WildFlyExtension;

@WildFlyExtension(module="org.jboss.as.security")
@MarshalDMR
public class SecurityFraction
extends Security<SecurityFraction>
implements Fraction<SecurityFraction> {
    public static SecurityFraction defaultSecurityFraction() {
        return new SecurityFraction().applyDefaults();
    }

    @PostConstruct
    public void postConstruct() {
        this.applyDefaults();
    }

    public SecurityFraction applyDefaults() {
        this.securityDomain(new SecurityDomain("other").cacheType(SecurityDomain.CacheType.DEFAULT).classicAuthentication(new ClassicAuthentication().loginModule(new LoginModule("RealmDirect").code("RealmDirect").flag(Flag.REQUIRED).moduleOptions((Map)new HashMap<Object, Object>(){
            {
                this.put("password-stacking", "useFirstPass");
            }
        }))));
        this.securityDomain(new SecurityDomain("jaspitest").cacheType(SecurityDomain.CacheType.DEFAULT).jaspiAuthentication(new JaspiAuthentication().loginModuleStack(new LoginModuleStack("dummy").loginModule(new LoginModule("Dummy").code("Dummy").flag(Flag.OPTIONAL))).authModule(new AuthModule("Dummy").code("Dummy"))));
        return this;
    }
}

