/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ProfileParsingCompletionHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;

public abstract class AbstractParserFactory {
    private static final String SUBSYSTEM = "subsystem";

    public static Optional<Map<QName, XMLElementReader<List<ModelNode>>>> mapParserNamespaces(AbstractParserFactory factory) {
        Map<QName, XMLElementReader> result = factory.create().entrySet().stream().collect(Collectors.toMap(e -> new QName(((QName)e.getKey()).getNamespaceURI(), SUBSYSTEM), e -> (XMLElementReader)e.getValue()));
        return Optional.of(result);
    }

    public abstract Map<QName, XMLElementReader<List<ModelNode>>> create();

    public class ParsingContext
    implements ExtensionParsingContext {
        Map<QName, XMLElementReader<List<ModelNode>>> parsers = new HashMap<QName, XMLElementReader<List<ModelNode>>>();

        public Map<QName, XMLElementReader<List<ModelNode>>> getParser() {
            return this.parsers;
        }

        public ProcessType getProcessType() {
            return ProcessType.STANDALONE_SERVER;
        }

        public RunningMode getRunningMode() {
            return RunningMode.NORMAL;
        }

        public void setSubsystemXmlMapping(String localName, String namespace, XMLElementReader<List<ModelNode>> parser) {
            this.parsers.put(new QName(namespace, localName), parser);
        }

        public void setProfileParsingCompletionHandler(ProfileParsingCompletionHandler profileParsingCompletionHandler) {
        }
    }
}

