/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import java.util.Set;
import org.wildfly.swarm.spi.api.ProjectStage;

public class StageConfig {
    private final ProjectStage stage;

    public StageConfig(ProjectStage stage) {
        this.stage = stage;
    }

    public Resolver<String> resolve(String name) {
        return new Builder(name).as(String.class);
    }

    public Set<String> keys() {
        return this.stage.getProperties().keySet();
    }

    public String getName() {
        return this.stage.getName();
    }

    public class Builder<T>
    implements Resolver<T> {
        private final String key;
        private Class<?> targetType;
        private T defaultValue;
        private Converter<T> converter;

        public Builder(String key) {
            this.key = key;
        }

        @Override
        public <N> Resolver<N> as(Class<N> clazz) {
            this.targetType = clazz;
            return this;
        }

        @Override
        public <N> Resolver<N> as(Class<N> clazz, Converter<T> converter) {
            this.targetType = clazz;
            this.converter = converter;
            return this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            String valueStr = StageConfig.this.stage.getProperties().get(this.key);
            T value = this.convert(valueStr);
            if (null == value) {
                throw new RuntimeException("Stage config '" + this.key + "' is missing");
            }
            return value;
        }

        @Override
        public Resolver<T> withDefault(T value) {
            this.defaultValue = value;
            return this;
        }

        private T convert(String value) {
            if (value == null) {
                return this.defaultValue != null ? (T)this.defaultValue : null;
            }
            Object result = null;
            if (this.converter != null) {
                try {
                    result = this.converter.convert(value);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (String.class.equals(this.targetType)) {
                result = value;
            } else if (Boolean.class.equals(this.targetType)) {
                Boolean isTrue = "TRUE".equalsIgnoreCase(value);
                isTrue = isTrue | "1".equalsIgnoreCase(value);
                result = isTrue;
            } else if (Integer.class.equals(this.targetType)) {
                result = Integer.parseInt(value);
            } else if (Long.class.equals(this.targetType)) {
                result = Long.parseLong(value);
            } else if (Float.class.equals(this.targetType)) {
                result = Float.valueOf(Float.parseFloat(value));
            } else if (Double.class.equals(this.targetType)) {
                result = Double.parseDouble(value);
            }
            return (T)result;
        }
    }

    public static interface Converter<T> {
        public T convert(String var1);
    }

    public static interface Resolver<T> {
        public T getValue();

        public Resolver<T> withDefault(T var1);

        public String getKey();

        public <N> Resolver<N> as(Class<N> var1);

        public <N> Resolver<N> as(Class<N> var1, Converter<T> var2);
    }
}

