/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.swarm.spi.api.ProjectStage;

public class StageConfig {
    private final ProjectStage stage;

    public StageConfig(ProjectStage stage) {
        this.stage = stage;
    }

    public Resolver<String> resolve(String name) {
        return new Builder(name).as(String.class);
    }

    public Set<String> keys() {
        return this.stage.getProperties().keySet();
    }

    public Set<String> simpleSubkeys(String prefix) {
        String searchPrefix = prefix + ".";
        HashSet<String> allKeys = new HashSet<String>();
        for (Object o : System.getProperties().keySet()) {
            allKeys.add(o.toString());
        }
        allKeys.addAll(this.keys());
        return allKeys.stream().filter(e -> e.startsWith(searchPrefix)).map(e -> e.replace(searchPrefix, "")).map(e -> {
            int dotLoc = e.indexOf(46);
            if (dotLoc < 0) {
                return e;
            }
            return e.substring(0, dotLoc);
        }).collect(Collectors.toSet());
    }

    public boolean hasKeyOrSubkeys(String key) {
        String searchPrefix = key + ".";
        HashSet<String> allKeys = new HashSet<String>();
        for (Object o : System.getProperties().keySet()) {
            allKeys.add(o.toString());
        }
        allKeys.addAll(this.keys());
        return allKeys.stream().anyMatch(e -> e.equals(key) || e.startsWith(searchPrefix));
    }

    public String getName() {
        return this.stage.getName();
    }

    public class Builder<T>
    implements Resolver<T> {
        private final String key;
        private Class<?> targetType;
        private T defaultValue;
        private Converter<?> converter;

        public Builder(String key) {
            this.key = key;
        }

        @Override
        public <N> Resolver<N> as(Class<N> clazz) {
            this.targetType = clazz;
            return this;
        }

        @Override
        public <N> Resolver<N> as(Class<N> clazz, Converter<N> converter) {
            this.targetType = clazz;
            this.converter = converter;
            return this;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            String valueStr = StageConfig.this.stage.getProperties().get(this.key);
            if (valueStr == null) {
                valueStr = System.getProperty(this.key);
            }
            T value = null;
            try {
                value = this.convert(valueStr);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            if (null == value) {
                throw new RuntimeException("Stage config '" + this.key + "' is missing");
            }
            return value;
        }

        @Override
        public boolean hasValue() {
            String valueStr = StageConfig.this.stage.getProperties().get(this.key);
            if (valueStr == null) {
                valueStr = System.getProperty(this.key);
            }
            return valueStr != null;
        }

        @Override
        public Resolver<T> withDefault(T value) {
            this.defaultValue = value;
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private T convert(String value) throws MalformedURLException {
            if (value == null) {
                if (this.defaultValue == null) return null;
                if (!(this.defaultValue instanceof String)) return this.defaultValue;
                value = (String)this.defaultValue;
            }
            Object result = null;
            if (this.converter != null) {
                try {
                    result = this.converter.convert(value);
                    return (T)result;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (String.class.equals(this.targetType)) {
                result = value;
                return (T)result;
            } else if (Boolean.class.equals(this.targetType)) {
                Boolean isTrue = "TRUE".equalsIgnoreCase(value);
                isTrue = isTrue | "1".equalsIgnoreCase(value);
                result = isTrue;
                return (T)result;
            } else if (Integer.class.equals(this.targetType)) {
                result = Integer.parseInt(value);
                return (T)result;
            } else if (Long.class.equals(this.targetType)) {
                result = Long.parseLong(value);
                return (T)result;
            } else if (Float.class.equals(this.targetType)) {
                result = Float.valueOf(Float.parseFloat(value));
                return (T)result;
            } else if (Double.class.equals(this.targetType)) {
                result = Double.parseDouble(value);
                return (T)result;
            } else {
                if (!URL.class.equals(this.targetType)) return (T)result;
                result = new URL(value);
            }
            return (T)result;
        }
    }

    public static interface Converter<T> {
        public T convert(String var1);
    }

    public static interface Resolver<T> {
        public T getValue();

        public boolean hasValue();

        public Resolver<T> withDefault(T var1);

        public String getKey();

        public <N> Resolver<N> as(Class<N> var1);

        public <N> Resolver<N> as(Class<N> var1, Converter<N> var2);
    }
}

