/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api.config;

import java.net.MalformedURLException;
import java.net.URL;
import org.wildfly.swarm.spi.api.config.ConfigKey;
import org.wildfly.swarm.spi.api.config.ConfigView;
import org.wildfly.swarm.spi.api.config.Converter;
import org.wildfly.swarm.spi.api.config.Resolver;

public class Builder<T>
implements Resolver<T> {
    private ConfigView view;
    private final ConfigKey key;
    private Class<?> targetType;
    private T defaultValue;
    private Converter<?> converter;

    public Builder(ConfigView view, ConfigKey key) {
        this.view = view;
        this.key = key;
    }

    @Override
    public <N> Resolver<N> as(Class<N> clazz) {
        this.targetType = clazz;
        return this;
    }

    @Override
    public <N> Resolver<N> as(Class<N> clazz, Converter<N> converter) {
        this.targetType = clazz;
        this.converter = converter;
        return this;
    }

    @Override
    public ConfigKey getKey() {
        return this.key;
    }

    @Override
    public T getValue() {
        Object originalValue = this.view.valueOf(this.key);
        String valueStr = originalValue != null ? originalValue.toString() : null;
        try {
            T value = this.convert(valueStr);
            if (null == value) {
                throw new RuntimeException("Stage config '" + this.key + "' is missing");
            }
            return value;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Override
    public boolean hasValue() {
        Object originalValue = this.view.valueOf(this.key);
        return originalValue != null;
    }

    @Override
    public Resolver<T> withDefault(T value) {
        this.defaultValue = value;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private T convert(String value) throws MalformedURLException {
        if (value == null) {
            if (this.defaultValue == null) return null;
            if (!(this.defaultValue instanceof String)) return this.defaultValue;
            value = (String)this.defaultValue;
        }
        Object result = null;
        if (this.converter != null) {
            try {
                result = this.converter.convert(value);
                return (T)result;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (String.class.equals(this.targetType)) {
            result = value;
            return (T)result;
        } else if (Boolean.class.equals(this.targetType)) {
            Boolean isTrue = "TRUE".equalsIgnoreCase(value);
            isTrue = isTrue | "1".equalsIgnoreCase(value);
            result = isTrue;
            return (T)result;
        } else if (Integer.class.equals(this.targetType)) {
            result = Integer.parseInt(value);
            return (T)result;
        } else if (Long.class.equals(this.targetType)) {
            result = Long.parseLong(value);
            return (T)result;
        } else if (Float.class.equals(this.targetType)) {
            result = Float.valueOf(Float.parseFloat(value));
            return (T)result;
        } else if (Double.class.equals(this.targetType)) {
            result = Double.parseDouble(value);
            return (T)result;
        } else {
            if (!URL.class.equals(this.targetType)) return (T)result;
            result = new URL(value);
        }
        return (T)result;
    }
}

