/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api.config;

import org.wildfly.swarm.spi.api.config.CompositeKey;
import org.wildfly.swarm.spi.api.config.ConfigKey;

public class SimpleKey
implements ConfigKey {
    private final String name;

    SimpleKey() {
        this.name = null;
    }

    public SimpleKey(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        if (this == ConfigKey.EMPTY) {
            return "";
        }
        return this.name;
    }

    @Override
    public String propertyName() {
        if (!this.name.contains(".")) {
            return this.name;
        }
        return '[' + this.name + ']';
    }

    @Override
    public SimpleKey head() {
        return this;
    }

    @Override
    public ConfigKey subkey(int offset) {
        if (offset == 0) {
            return this;
        }
        return ConfigKey.EMPTY;
    }

    @Override
    public ConfigKey append(ConfigKey key) {
        if (this == ConfigKey.EMPTY) {
            return key;
        }
        if (key == ConfigKey.EMPTY) {
            return this;
        }
        return new CompositeKey(this.name).append(key);
    }

    @Override
    public ConfigKey append(String ... names) {
        ConfigKey cur = this;
        for (String each : names) {
            cur = cur.append(new SimpleKey(each));
        }
        return cur;
    }

    public int hashCode() {
        if (this == ConfigKey.EMPTY) {
            return System.identityHashCode(this);
        }
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == ConfigKey.EMPTY) {
            return obj == ConfigKey.EMPTY;
        }
        if (obj instanceof SimpleKey) {
            return this.name.equals(((SimpleKey)obj).name);
        }
        return false;
    }

    public String toString() {
        if (this == ConfigKey.EMPTY) {
            return "(empty)";
        }
        return this.name();
    }
}

