/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.springboot.web;

import io.undertow.UndertowMessages;
import io.undertow.server.handlers.resource.FileResourceManager;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.URLResource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.springframework.util.Assert;
import org.wildfly.swarm.springboot.web.SwarmUndertowServletContainer;

public class SwarmUndertowServletContainerFactory
extends AbstractEmbeddedServletContainerFactory {
    private ArrayList<UndertowDeploymentInfoCustomizer> deploymentInfoCustomizers = new ArrayList();

    public EmbeddedServletContainer getEmbeddedServletContainer(ServletContextInitializer ... initializers) {
        ServletContextInitializer[] mergedInitializers = this.mergeInitializers(initializers);
        return new SwarmUndertowServletContainer(this, mergedInitializers);
    }

    public void setDeploymentInfoCustomizers(Collection<? extends UndertowDeploymentInfoCustomizer> customizers) {
        System.err.println("set deployment info customers: " + customizers);
        Assert.notNull(customizers, (String)"Customizers must not be null");
        this.deploymentInfoCustomizers = new ArrayList<UndertowDeploymentInfoCustomizer>(customizers);
    }

    public Collection<UndertowDeploymentInfoCustomizer> getDeploymentInfoCustomizers() {
        return this.deploymentInfoCustomizers;
    }

    public void addDeploymentInfoCustomizers(UndertowDeploymentInfoCustomizer ... customizers) {
        System.err.println("add deployment info customers: " + Arrays.asList(customizers));
        Assert.notNull((Object)customizers, (String)"UndertowDeploymentInfoCustomizers must not be null");
        this.deploymentInfoCustomizers.addAll(Arrays.asList(customizers));
    }

    ResourceManager getDocumentRootResourceManager() {
        File root = this.getCanonicalDocumentRoot();
        if (root.isDirectory()) {
            return new FileResourceManager(root, 0L);
        }
        if (root.isFile()) {
            return new JarResourceManager(root);
        }
        return ResourceManager.EMPTY_RESOURCE_MANAGER;
    }

    private File getCanonicalDocumentRoot() {
        try {
            File root = this.getValidDocumentRoot();
            root = root != null ? root : this.createTempDir("undertow-docbase");
            return root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot get canonical document root", e);
        }
    }

    private static class JarResourceManager
    implements ResourceManager {
        private final String jarPath;

        JarResourceManager(File jarFile) {
            this(jarFile.getAbsolutePath());
        }

        JarResourceManager(String jarPath) {
            this.jarPath = jarPath;
        }

        public Resource getResource(String path) throws IOException {
            URL url = new URL("jar:file:" + this.jarPath + "!" + path);
            URLResource resource = new URLResource(url, url.openConnection(), path);
            if (resource.getContentLength() < 0L) {
                return null;
            }
            return resource;
        }

        public boolean isResourceChangeListenerSupported() {
            return false;
        }

        public void registerResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void removeResourceChangeListener(ResourceChangeListener listener) {
            throw UndertowMessages.MESSAGES.resourceChangeListenerNotSupported();
        }

        public void close() throws IOException {
        }
    }
}

