/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.springboot.web;

import io.undertow.Handlers;
import io.undertow.server.HttpHandler;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ErrorPage;
import io.undertow.servlet.api.MimeMapping;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletStackTraces;
import io.undertow.servlet.handlers.DefaultServlet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import javax.servlet.ServletException;
import org.jboss.msc.service.ServiceName;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.MimeMappings;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.undertow.UndertowDeploymentInfoCustomizer;
import org.wildfly.swarm.springboot.util.Bridge;
import org.wildfly.swarm.springboot.web.Initializer;
import org.wildfly.swarm.springboot.web.SwarmUndertowServletContainerFactory;

public class SwarmUndertowServletContainer
implements EmbeddedServletContainer {
    private final SwarmUndertowServletContainerFactory factory;

    public SwarmUndertowServletContainer(SwarmUndertowServletContainerFactory factory, ServletContextInitializer ... initializers) {
        this.factory = factory;
        this.factory.getJspServlet().setRegistered(false);
        System.err.println("CONTEXT --> " + this.factory.getContextPath());
        Object servletContainerService = Bridge.lookup((ServiceName)ServiceName.JBOSS.append(new String[]{"undertow", "servlet-container", "default"}));
        try {
            Method getContainer = servletContainerService.getClass().getMethod("getServletContainer", new Class[0]);
            ServletContainer servletContainer = (ServletContainer)getContainer.invoke(servletContainerService, new Object[0]);
            DeploymentManager manager = this.createDeploymentManager(servletContainer, initializers);
            manager.deploy();
            HttpHandler httpHandler = manager.start();
            if (!this.factory.getContextPath().equals("")) {
                httpHandler = Handlers.path().addPrefixPath(this.factory.getContextPath(), httpHandler);
            }
            Object hostService = Bridge.lookup((ServiceName)ServiceName.JBOSS.append(new String[]{"undertow", "default-server", "default-host"}));
            Method registerDeployment = hostService.getClass().getMethod("registerDeployment", Deployment.class, HttpHandler.class);
            registerDeployment.invoke(hostService, manager.getDeployment(), httpHandler);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
    }

    private DeploymentManager createDeploymentManager(ServletContainer container, ServletContextInitializer ... initializers) {
        DeploymentInfo deployment = Servlets.deployment();
        Initializer initializer = new Initializer(initializers);
        ServletContainerInitializerInfo initInfo = new ServletContainerInitializerInfo(Initializer.class, initializer.instanceFactory(), Collections.emptySet());
        deployment.addServletContainerInitalizers(new ServletContainerInitializerInfo[]{initInfo});
        deployment.setClassLoader(Thread.currentThread().getContextClassLoader());
        deployment.setContextPath(this.factory.getContextPath());
        deployment.setDisplayName("spring-boot");
        deployment.setDeploymentName("spring-boot");
        if (this.factory.isRegisterDefaultServlet()) {
            deployment.addServlet(Servlets.servlet((String)"default", DefaultServlet.class));
        }
        this.configureErrorPages(deployment);
        deployment.setServletStackTraces(ServletStackTraces.NONE);
        deployment.setResourceManager(this.factory.getDocumentRootResourceManager());
        this.configureMimeMappings(deployment);
        for (UndertowDeploymentInfoCustomizer customizer : this.factory.getDeploymentInfoCustomizers()) {
            customizer.customize(deployment);
        }
        DeploymentManager manager = container.addDeployment(deployment);
        manager.deploy();
        SessionManager sessionManager = manager.getDeployment().getSessionManager();
        sessionManager.setDefaultSessionTimeout(-1);
        return manager;
    }

    private void configureMimeMappings(DeploymentInfo servletBuilder) {
        for (MimeMappings.Mapping mimeMapping : this.factory.getMimeMappings()) {
            servletBuilder.addMimeMapping(new MimeMapping(mimeMapping.getExtension(), mimeMapping.getMimeType()));
        }
    }

    private void configureErrorPages(DeploymentInfo servletBuilder) {
        for (org.springframework.boot.context.embedded.ErrorPage errorPage : this.factory.getErrorPages()) {
            servletBuilder.addErrorPage(this.getUndertowErrorPage(errorPage));
        }
    }

    private ErrorPage getUndertowErrorPage(org.springframework.boot.context.embedded.ErrorPage errorPage) {
        if (errorPage.getStatus() != null) {
            return new ErrorPage(errorPage.getPath(), errorPage.getStatusCode());
        }
        if (errorPage.getException() != null) {
            return new ErrorPage(errorPage.getPath(), errorPage.getException());
        }
        return new ErrorPage(errorPage.getPath());
    }

    public void start() throws EmbeddedServletContainerException {
    }

    public void stop() throws EmbeddedServletContainerException {
    }

    public int getPort() {
        return 8080;
    }
}

