/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.springboot;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringApplicationContextService
implements Service<ApplicationContext> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"swarm", "spring-boot", "context"});
    private final ClassLoader classLoader;
    private final Class source;
    private ConfigurableApplicationContext context;

    public static void addService(ServiceTarget target, ClassLoader classLoader, Class source) {
        target.addService(SERVICE_NAME, (Service)new SpringApplicationContextService(classLoader, source)).install();
    }

    public SpringApplicationContextService(ClassLoader classLoader, Class source) {
        this.classLoader = classLoader;
        this.source = source;
    }

    public void start(StartContext context) throws StartException {
        context.asynchronous();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            this.context = SpringApplication.run((Object[])new Object[]{this.source}, (String[])new String[0]);
            context.complete();
        }
        catch (Throwable t) {
            context.failed(new StartException(t));
            t.printStackTrace();
        }
    }

    public void stop(StopContext context) {
        this.context.stop();
    }

    public ApplicationContext getValue() throws IllegalStateException, IllegalArgumentException {
        return this.context;
    }
}

