/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.springboot.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.swarm.container.internal.Deployer;
import org.wildfly.swarm.springboot.MSCBridgeActivator;

public class Bridge {
    private static final ServiceName DEPLOYER_SERVICE = ServiceName.of((String[])new String[]{"swarm", "deployer"});

    public static Deployer getDeployer() {
        return (Deployer)MSCBridgeActivator.REGISTRY.getService(DEPLOYER_SERVICE).getValue();
    }

    public static void addObject(Object object, String ... nameParts) {
        ServiceName name = ServiceName.of((String[])nameParts);
        Bridge.addObject(object, name);
    }

    public static void addObject(Object object, ServiceName name) {
        MSCBridgeActivator.TARGET.addService(name, (Service)new ValueService((Value)new ImmediateValue(object))).install();
    }

    public static <T> T lookup(ServiceName name) {
        try {
            ServiceController s = MSCBridgeActivator.REGISTRY.getService(name);
            s.setMode(ServiceController.Mode.ACTIVE);
            return (T)s.awaitValue(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (TimeoutException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> List<T> getChildrenOf(ServiceName parentName, Class<T> type) {
        List names = MSCBridgeActivator.REGISTRY.getServiceNames();
        ArrayList<Object> objects = new ArrayList<Object>();
        for (ServiceName name : names) {
            if (!parentName.isParentOf(name)) continue;
            objects.add(MSCBridgeActivator.REGISTRY.getService(name).getValue());
        }
        return objects;
    }
}

