/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SwaggerConfig {
    private final HashMap<Key, Object> config = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwaggerConfig(InputStream input) {
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                int separatorIndex = line.indexOf(":");
                Key key = Key.valueOf(line.substring(0, separatorIndex));
                String[] value = line.substring(separatorIndex + 1);
                if (key == Key.SCHEMES) {
                    value = value.split(",");
                }
                this.put(key, value);
            }
        }
        catch (IOException e) {
            System.err.println("ERROR reading SwaggerConfigurationAsset" + e);
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public SwaggerConfig() {
    }

    public SwaggerConfig put(Key key, Object value) {
        this.config.put(key, value);
        return this;
    }

    public Object get(Key key) {
        return this.config.get((Object)key);
    }

    public Set<Map.Entry<Key, Object>> entrySet() {
        return this.config.entrySet();
    }

    public static enum Key {
        TITLE,
        PACKAGES,
        DESCRIPTION,
        TERMS_OF_SERVICE_URL,
        CONTACT,
        LICENSE,
        LICENSE_URL,
        VERSION,
        SCHEMES,
        HOST,
        ROOT,
        PRETTY_PRINT;

    }
}

