/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.internal;

import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.impl.base.ArchiveBase;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.wildfly.swarm.msc.ServiceActivatorArchive;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.swagger.SwaggerArchive;
import org.wildfly.swarm.swagger.internal.SwaggerConfigurationAsset;

public class SwaggerArchiveImpl
extends AssignableBase<ArchiveBase<?>>
implements SwaggerArchive {
    public static final String SERVICE_ACTIVATOR_CLASS_NAME = "org.wildfly.swarm.swagger.runtime.SwaggerActivator";
    private SwaggerConfigurationAsset configurationAsset;

    public SwaggerArchiveImpl(ArchiveBase<?> archive) {
        super(archive);
        if (!((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).containsServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME)) {
            ((ServiceActivatorArchive)this.as(ServiceActivatorArchive.class)).addServiceActivator(SERVICE_ACTIVATOR_CLASS_NAME);
            ((JARArchive)this.as(JARArchive.class)).addModule("org.wildfly.swarm.swagger", "runtime");
        }
        this.loadOrCreateConfigurationAsset();
    }

    public SwaggerConfigurationAsset getConfigurationAsset() {
        return this.configurationAsset;
    }

    @Override
    public SwaggerArchive setResourcePackages(String ... packages) {
        this.getConfigurationAsset().register(packages);
        return this;
    }

    @Override
    public SwaggerArchive setTitle(String title) {
        this.getConfigurationAsset().setTitle(title);
        return this;
    }

    @Override
    public SwaggerArchive setDescription(String description) {
        this.getConfigurationAsset().setDescription(description);
        return this;
    }

    @Override
    public SwaggerArchive setTermsOfServiceUrl(String url) {
        this.getConfigurationAsset().setTermsOfServiceUrl(url);
        return this;
    }

    @Override
    public SwaggerArchive setContact(String contact) {
        this.getConfigurationAsset().setContact(contact);
        return this;
    }

    @Override
    public SwaggerArchive setLicense(String license) {
        this.getConfigurationAsset().setLicense(license);
        return this;
    }

    @Override
    public SwaggerArchive setLicenseUrl(String licenseUrl) {
        this.getConfigurationAsset().setLicenseUrl(licenseUrl);
        return this;
    }

    @Override
    public SwaggerArchive setVersion(String version) {
        this.getConfigurationAsset().setVersion(version);
        return this;
    }

    @Override
    public SwaggerArchive setSchemes(String ... schemes) {
        this.getConfigurationAsset().setSchemes(schemes);
        return this;
    }

    @Override
    public SwaggerArchive setHost(String host) {
        this.getConfigurationAsset().setHost(host);
        return this;
    }

    @Override
    public SwaggerArchive setContextRoot(String root) {
        this.getConfigurationAsset().setContextRoot(root);
        return this;
    }

    @Override
    public SwaggerArchive setPrettyPrint(boolean prettyPrint) {
        this.getConfigurationAsset().setPrettyPrint(prettyPrint);
        return this;
    }

    @Override
    public boolean hasResourcePackages() {
        return this.getConfigurationAsset().getResourcePackages() != null;
    }

    private void loadOrCreateConfigurationAsset() {
        Node node = ((ArchiveBase)this.getArchive()).get("META-INF/swarm.swagger.conf");
        if (node != null) {
            Asset asset = node.getAsset();
            this.configurationAsset = asset instanceof SwaggerConfigurationAsset ? (SwaggerConfigurationAsset)asset : new SwaggerConfigurationAsset(asset.openStream());
        } else {
            this.configurationAsset = new SwaggerConfigurationAsset();
            ((ArchiveBase)this.getArchive()).add((Asset)this.configurationAsset, "META-INF/swarm.swagger.conf");
        }
    }
}

