/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.runtime;

import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.wildfly.swarm.container.runtime.AbstractServerConfiguration;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.swagger.SwaggerArchive;
import org.wildfly.swarm.swagger.SwaggerFraction;

public class SwaggerConfiguration
extends AbstractServerConfiguration<SwaggerFraction> {
    public SwaggerConfiguration() {
        super(SwaggerFraction.class);
    }

    public SwaggerFraction defaultFraction() {
        return new SwaggerFraction();
    }

    public void prepareArchive(Archive<?> a) {
        try {
            JAXRSArchive deployment = (JAXRSArchive)((JAXRSArchive)a.as(JAXRSArchive.class)).addModule("io.swagger");
            SwaggerArchive swaggerArchive = (SwaggerArchive)deployment.as(SwaggerArchive.class);
            swaggerArchive.setContextRoot(deployment.getContextRoot());
            if (!swaggerArchive.hasResourcePackages()) {
                String packageName = null;
                for (Map.Entry entry : deployment.getContent().entrySet()) {
                    ArchivePath key = (ArchivePath)entry.getKey();
                    if (!key.get().endsWith(".class")) continue;
                    String parentPath = key.getParent().get();
                    parentPath = parentPath.replaceFirst("/", "");
                    String parentPackage = parentPath.replaceFirst(".*/classes/", "");
                    if ((parentPackage = parentPackage.replaceAll("/", ".")).startsWith("org.wildfly.swarm")) {
                        System.out.println("[Swagger] Ignoring swarm package " + parentPackage);
                        continue;
                    }
                    packageName = parentPackage;
                    break;
                }
                if (packageName == null) {
                    System.err.println("[Swagger] No eligible packages for Swagger to scan.");
                } else {
                    System.out.println("[Swagger] Configuring Swagger with " + packageName);
                    swaggerArchive.setResourcePackages(new String[]{packageName});
                }
            }
            deployment.addResource(ApiListingResource.class);
            deployment.addResource(SwaggerSerializers.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<ModelNode> getList(SwaggerFraction fraction) throws Exception {
        return Collections.emptyList();
    }
}

