/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.webapp;

import java.io.File;
import java.io.IOException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.wildfly.swarm.spi.api.ArtifactLookup;
import org.wildfly.swarm.spi.api.Defaultable;
import org.wildfly.swarm.spi.api.Fraction;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.swagger.webapp.SwaggerWebAppMessages;

@Configurable(value="swarm.swagger.web-app")
public class SwaggerWebAppFraction
implements Fraction<SwaggerWebAppFraction> {
    private Defaultable<String> context = Defaultable.string((String)"/swagger-ui");
    private Archive<?> webContent;

    public String getContext() {
        return (String)this.context.get();
    }

    public void setContext(String context) {
        this.context.set((Object)context);
    }

    public SwaggerWebAppFraction addWebContent(String content) {
        if (content == null) {
            return this;
        }
        if (content.equals("")) {
            return this;
        }
        File maybeFile = new File(content);
        if (!maybeFile.exists()) {
            try {
                this.webContent = ArtifactLookup.get().artifact(content);
            }
            catch (Exception e) {
                SwaggerWebAppMessages.MESSAGES.unableToLocateWebContent(content);
            }
        } else if (maybeFile.isDirectory()) {
            try {
                this.webContent = this.loadFromDirectory(maybeFile);
            }
            catch (IOException e) {
                SwaggerWebAppMessages.MESSAGES.unableToLocateWebContent(maybeFile.toString());
            }
        } else {
            this.webContent = (Archive)ShrinkWrap.createFromZipFile(JARArchive.class, (File)maybeFile);
        }
        return this;
    }

    public Archive<?> getWebContent() {
        return this.webContent;
    }

    private Archive<?> loadFromDirectory(File directory) throws IOException {
        JARArchive archive = (JARArchive)ShrinkWrap.create(JARArchive.class);
        ((ExplodedImporter)archive.as(ExplodedImporter.class)).importDirectory(directory);
        return archive;
    }
}

