/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.webapp.runtime;

import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.wildfly.swarm.spi.api.JARArchive;
import org.wildfly.swarm.swagger.webapp.SwaggerWebAppFraction;
import org.wildfly.swarm.swagger.webapp.runtime.SwaggerDefaultUrlChangerServlet;
import org.wildfly.swarm.undertow.WARArchive;

@ApplicationScoped
public class SwaggerWebAppDeploymentProducer {
    private static final Pattern PATTERN = Pattern.compile("/META-INF/resources/webjars/swagger-ui/([^\\/]+/)(.*)");
    @Inject
    @Any
    private SwaggerWebAppFraction fraction;

    @Produces
    public Archive swaggerWebApp() throws ModuleLoadException, IOException {
        Module module = Module.getBootModuleLoader().loadModule("org.webjars.swagger-ui");
        URL resource = module.getExportedResource("swagger-ui.jar");
        JARArchive webJar = (JARArchive)ShrinkWrap.create(JARArchive.class);
        ((ZipImporter)webJar.as(ZipImporter.class)).importFrom(resource.openStream());
        JARArchive relocatedJar = (JARArchive)ShrinkWrap.create(JARArchive.class);
        Map content = webJar.getContent();
        for (ArchivePath path : content.keySet()) {
            Matcher matcher;
            Node node = (Node)content.get(path);
            Asset asset = node.getAsset();
            if (asset == null || !(matcher = PATTERN.matcher(path.get())).matches()) continue;
            MatchResult result = matcher.toMatchResult();
            String newPath = "/META-INF/resources/" + result.group(2);
            relocatedJar.add(asset, newPath);
        }
        WARArchive war = (WARArchive)((WARArchive)((WARArchive)ShrinkWrap.create(WARArchive.class, (String)"swagger-ui.war")).addAsLibrary((Archive)relocatedJar)).setContextRoot(this.fraction.getContext());
        war.addClass(SwaggerDefaultUrlChangerServlet.class);
        Archive<?> userContent = this.fraction.getWebContent();
        if (userContent != null) {
            war.merge(userContent);
        }
        return war;
    }
}

