/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.runtime;

import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Singleton;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.swagger.SwaggerArchive;

@Singleton
public class SwaggerArchivePreparer
implements ArchivePreparer {
    public void prepareArchive(Archive<?> archive) {
        if (archive instanceof JAXRSArchive) {
            try {
                JAXRSArchive deployment = (JAXRSArchive)archive.as(JAXRSArchive.class);
                deployment.addModule("io.swagger");
                SwaggerArchive swaggerArchive = (SwaggerArchive)deployment.as(SwaggerArchive.class);
                if (!swaggerArchive.hasContextRoot()) {
                    swaggerArchive.setContextRoot(deployment.getContextRoot());
                }
                if (!swaggerArchive.hasResourcePackages()) {
                    String packageName = null;
                    for (Map.Entry entry : deployment.getContent().entrySet()) {
                        ArchivePath key = (ArchivePath)entry.getKey();
                        if (!key.get().endsWith(".class")) continue;
                        String parentPath = key.getParent().get();
                        parentPath = parentPath.replaceFirst("/", "");
                        String parentPackage = parentPath.replaceFirst(".*/classes/", "");
                        if ((parentPackage = parentPackage.replaceAll("/", ".")).startsWith("org.wildfly.swarm")) {
                            System.out.println("[Swagger] Ignoring swarm package " + parentPackage);
                            continue;
                        }
                        packageName = parentPackage;
                        break;
                    }
                    if (packageName == null) {
                        System.err.println("[Swagger] No eligible packages for Swagger to scan.");
                    } else {
                        System.out.println("[Swagger] Configuring Swagger with package " + packageName);
                        swaggerArchive.setResourcePackages(packageName);
                    }
                } else {
                    System.out.println("[SWAGGER] Configuring Swagger with packages " + Arrays.toString(swaggerArchive.getResourcePackages()));
                }
                deployment.addResource(ApiListingResource.class);
                deployment.addResource(SwaggerSerializers.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

