/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SwaggerConfig {
    private final HashMap<Key, Object> config = new HashMap();

    public SwaggerConfig(InputStream input) throws IOException {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(input));){
            String line;
            while ((line = in.readLine()) != null) {
                int separatorIndex = line.indexOf(":");
                Key key = Key.valueOf(line.substring(0, separatorIndex).toUpperCase());
                String[] value = line.substring(separatorIndex + 1);
                if (key == Key.SCHEMES || key == Key.PACKAGES) {
                    String[] parts = value.split(",");
                    for (int i = 0; i < parts.length; ++i) {
                        parts[i] = parts[i].trim();
                    }
                    value = parts;
                } else {
                    value = value.toString().trim();
                }
                this.put(key, value);
            }
        }
        catch (IllegalArgumentException ia) {
            throw new RuntimeException("Invalid key: " + ia.getMessage());
        }
    }

    public SwaggerConfig() {
    }

    public SwaggerConfig put(Key key, Object value) {
        this.config.put(key, value);
        return this;
    }

    public Object get(Key key) {
        return this.config.get((Object)key);
    }

    public Set<Map.Entry<Key, Object>> entrySet() {
        return this.config.entrySet();
    }

    public static enum Key {
        TITLE,
        PACKAGES,
        DESCRIPTION,
        TERMS_OF_SERVICE_URL,
        CONTACT,
        LICENSE,
        LICENSE_URL,
        VERSION,
        SCHEMES,
        HOST,
        ROOT,
        PRETTY_PRINT;

    }
}

