/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.runtime;

import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.Arrays;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.wildfly.swarm.jaxrs.JAXRSArchive;
import org.wildfly.swarm.spi.api.ArchivePreparer;
import org.wildfly.swarm.swagger.SwaggerArchive;
import org.wildfly.swarm.swagger.SwaggerMessages;

@ApplicationScoped
public class SwaggerArchivePreparer
implements ArchivePreparer {
    public void prepareArchive(Archive<?> archive) {
        if (archive instanceof JAXRSArchive) {
            JAXRSArchive deployment = (JAXRSArchive)archive.as(JAXRSArchive.class);
            deployment.addModule("io.swagger");
            SwaggerArchive swaggerArchive = (SwaggerArchive)deployment.as(SwaggerArchive.class);
            if (!swaggerArchive.hasContextRoot()) {
                swaggerArchive.setContextRoot(deployment.getContextRoot());
            }
            if (!swaggerArchive.hasResourcePackages()) {
                String packageName = null;
                for (Map.Entry entry : deployment.getContent().entrySet()) {
                    ArchivePath key = (ArchivePath)entry.getKey();
                    if (!key.get().endsWith(".class")) continue;
                    String parentPath = key.getParent().get();
                    parentPath = parentPath.replaceFirst("/", "");
                    String parentPackage = parentPath.replaceFirst(".*/classes/", "");
                    if ((parentPackage = parentPackage.replaceAll("/", ".")).startsWith("org.wildfly.swarm")) {
                        SwaggerMessages.MESSAGES.ignoringPackage(parentPackage);
                        continue;
                    }
                    packageName = parentPackage;
                    break;
                }
                if (packageName == null) {
                    SwaggerMessages.MESSAGES.noEligiblePackages(archive.getName());
                } else {
                    SwaggerMessages.MESSAGES.configureSwaggerForPackage(archive.getName(), packageName);
                    swaggerArchive.setResourcePackages(packageName);
                }
            } else {
                SwaggerMessages.MESSAGES.configureSwaggerForSeveralPackages(archive.getName(), Arrays.asList(swaggerArchive.getResourcePackages()));
            }
            deployment.addResource(ApiListingResource.class);
            deployment.addResource(SwaggerSerializers.class);
        }
    }
}

