/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.wildfly.swarm.swagger.SwaggerConfig;

public class SwaggerConfigurationAsset
implements Asset {
    private final SwaggerConfig configuration;

    public SwaggerConfigurationAsset() {
        this.configuration = new SwaggerConfig();
    }

    public SwaggerConfigurationAsset(InputStream is) throws IOException {
        this.configuration = new SwaggerConfig(is);
    }

    public InputStream openStream() {
        StringBuilder builder = new StringBuilder();
        Set<Map.Entry<SwaggerConfig.Key, Object>> entries = this.configuration.entrySet();
        for (Map.Entry<SwaggerConfig.Key, Object> entry : entries) {
            Object value = entry.getValue();
            if (value == null) continue;
            builder.append((Object)((Object)entry.getKey()) + ":" + this.valueFor(value) + "\n");
        }
        return new ByteArrayInputStream(builder.toString().getBytes());
    }

    public SwaggerConfigurationAsset register(String[] packageNames) {
        this.configuration.put(SwaggerConfig.Key.PACKAGES, packageNames);
        return this;
    }

    public SwaggerConfigurationAsset setTitle(String title) {
        this.configuration.put(SwaggerConfig.Key.TITLE, title);
        return this;
    }

    public SwaggerConfigurationAsset setDescription(String description) {
        this.configuration.put(SwaggerConfig.Key.DESCRIPTION, description);
        return this;
    }

    public SwaggerConfigurationAsset setTermsOfServiceUrl(String termsOfServiceUrl) {
        this.configuration.put(SwaggerConfig.Key.TERMS_OF_SERVICE_URL, termsOfServiceUrl);
        return this;
    }

    public SwaggerConfigurationAsset setContact(String contact) {
        this.configuration.put(SwaggerConfig.Key.CONTACT, contact);
        return this;
    }

    public SwaggerConfigurationAsset setLicense(String license) {
        this.configuration.put(SwaggerConfig.Key.LICENSE, license);
        return this;
    }

    public SwaggerConfigurationAsset setLicenseUrl(String licenseUrl) {
        this.configuration.put(SwaggerConfig.Key.LICENSE_URL, licenseUrl);
        return this;
    }

    public SwaggerConfigurationAsset setVersion(String version) {
        this.configuration.put(SwaggerConfig.Key.VERSION, version);
        return this;
    }

    public SwaggerConfigurationAsset setSchemes(String[] schemes) {
        this.configuration.put(SwaggerConfig.Key.SCHEMES, schemes);
        return this;
    }

    public SwaggerConfigurationAsset setHost(String host) {
        this.configuration.put(SwaggerConfig.Key.HOST, host);
        return this;
    }

    public SwaggerConfigurationAsset setContextRoot(String root) {
        this.configuration.put(SwaggerConfig.Key.ROOT, root);
        return this;
    }

    public String getContextRoot() {
        return (String)this.configuration.get(SwaggerConfig.Key.ROOT);
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.configuration.put(SwaggerConfig.Key.PRETTY_PRINT, prettyPrint);
    }

    public String[] getResourcePackages() {
        return (String[])this.configuration.get(SwaggerConfig.Key.PACKAGES);
    }

    private String valueFor(Object value) {
        if (value instanceof String[]) {
            StringBuilder buf = new StringBuilder();
            for (String name : (String[])value) {
                buf.append(name).append(",");
            }
            buf.setLength(Math.max(buf.length() - 1, 0));
            return buf.toString();
        }
        return value.toString();
    }
}

