/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.runtime;

import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.wildfly.swarm.spi.api.DeploymentProcessor;
import org.wildfly.swarm.spi.api.annotations.Configurable;
import org.wildfly.swarm.spi.runtime.annotations.DeploymentScoped;
import org.wildfly.swarm.swagger.SwaggerArchive;
import org.wildfly.swarm.swagger.SwaggerMessages;
import org.wildfly.swarm.undertow.WARArchive;

@DeploymentScoped
public class SwaggerArchivePreparer
implements DeploymentProcessor {
    @Configurable(value="swarm.deployment.*.swagger.title")
    private String title;
    @Configurable(value="swarm.deployment.*.swagger.description")
    private String description;
    @Configurable(value="swarm.deployment.*.swagger.packages")
    private List<String> packages;
    @Configurable(value="swarm.deployment.*.swagger.tos-url")
    private String tosUrl;
    @Configurable(value="swarm.deployment.*.swagger.license")
    private String license;
    @Configurable(value="swarm.deployment.*.swagger.license-url")
    private String licenseUrl;
    @Configurable(value="swarm.deployment.*.swagger.version")
    private String version;
    @Configurable(value="swarm.deployment.*.swagger.schemes")
    private List<String> schemes;
    @Configurable(value="swarm.deployment.*.swagger.host")
    private String host;
    @Configurable(value="swarm.deployment.*.swagger.root")
    private String root;
    private final Archive archive;

    @Inject
    public SwaggerArchivePreparer(Archive archive) {
        this.archive = archive;
    }

    public void process() {
        if (this.archive.getName().endsWith(".war")) {
            WARArchive deployment = (WARArchive)this.archive.as(WARArchive.class);
            deployment.addModule("io.swagger");
            SwaggerArchive swaggerArchive = (SwaggerArchive)deployment.as(SwaggerArchive.class);
            if (this.title != null) {
                swaggerArchive.setTitle(this.title);
            }
            if (this.description != null) {
                swaggerArchive.setDescription(this.description);
            }
            if (this.packages != null && !this.packages.isEmpty()) {
                swaggerArchive.setResourcePackages(this.packages.toArray(new String[this.packages.size()]));
            }
            if (this.tosUrl != null) {
                swaggerArchive.setTermsOfServiceUrl(this.tosUrl);
            }
            if (this.license != null) {
                swaggerArchive.setLicense(this.license);
            }
            if (this.licenseUrl != null) {
                swaggerArchive.setLicenseUrl(this.licenseUrl);
            }
            if (this.version != null) {
                swaggerArchive.setVersion(this.version);
            }
            if (this.schemes != null && !this.schemes.isEmpty()) {
                swaggerArchive.setSchemes(this.schemes.toArray(new String[this.schemes.size()]));
            }
            if (this.host != null) {
                swaggerArchive.setHost(this.host);
            }
            if (this.root != null) {
                swaggerArchive.setContextRoot(this.root);
            } else if (!swaggerArchive.hasContextRoot()) {
                swaggerArchive.setContextRoot(deployment.getContextRoot());
            }
            if (!swaggerArchive.hasResourcePackages()) {
                String packageName = null;
                for (Map.Entry entry : deployment.getContent().entrySet()) {
                    ArchivePath key = (ArchivePath)entry.getKey();
                    if (!key.get().endsWith(".class")) continue;
                    String parentPath = key.getParent().get();
                    parentPath = parentPath.replaceFirst("/", "");
                    String parentPackage = parentPath.replaceFirst(".*/classes/", "");
                    if ((parentPackage = parentPackage.replaceAll("/", ".")).startsWith("org.wildfly.swarm")) {
                        SwaggerMessages.MESSAGES.ignoringPackage(parentPackage);
                        continue;
                    }
                    packageName = parentPackage;
                    break;
                }
                if (packageName == null) {
                    SwaggerMessages.MESSAGES.noEligiblePackages(this.archive.getName());
                } else {
                    SwaggerMessages.MESSAGES.configureSwaggerForPackage(this.archive.getName(), packageName);
                    swaggerArchive.setResourcePackages(packageName);
                }
            } else {
                SwaggerMessages.MESSAGES.configureSwaggerForSeveralPackages(this.archive.getName(), Arrays.asList(swaggerArchive.getResourcePackages()));
            }
            deployment.addClass(ApiListingResource.class);
            deployment.addClass(SwaggerSerializers.class);
        }
    }
}

