/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swagger.deployment;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.ws.rs.core.Application;
import org.wildfly.swarm.swagger.deployment.AddSwaggerResources;
import org.wildfly.swarm.swagger.deployment.SwaggerRestApplicationInterceptor;

public class SwaggerExtension
implements Extension {
    private static final Annotation ADD_SWAGGER_ANNOTATION = () -> AddSwaggerResources.class;

    public void processBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        event.addInterceptorBinding(beanManager.createAnnotatedType(AddSwaggerResources.class));
        event.addAnnotatedType(beanManager.createAnnotatedType(SwaggerRestApplicationInterceptor.class));
    }

    public void processAfterTypeDiscovery(@Observes AfterTypeDiscovery event) {
        if (!event.getInterceptors().contains(SwaggerRestApplicationInterceptor.class)) {
            event.getInterceptors().add(SwaggerRestApplicationInterceptor.class);
        }
    }

    public <T extends Application> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        final AnnotatedType annotatedType = event.getAnnotatedType();
        if (Application.class.isAssignableFrom(annotatedType.getJavaClass())) {
            event.setAnnotatedType(new AnnotatedType<T>(){
                private final Annotation ADD_SWAGGER_ANNOTATION = () -> AddSwaggerResources.class;

                public Class<T> getJavaClass() {
                    return annotatedType.getJavaClass();
                }

                public Set<AnnotatedConstructor<T>> getConstructors() {
                    return annotatedType.getConstructors();
                }

                public Set<AnnotatedMethod<? super T>> getMethods() {
                    return annotatedType.getMethods();
                }

                public Set<AnnotatedField<? super T>> getFields() {
                    return annotatedType.getFields();
                }

                public Type getBaseType() {
                    return annotatedType.getBaseType();
                }

                public Set<Type> getTypeClosure() {
                    return annotatedType.getTypeClosure();
                }

                public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
                    if (AddSwaggerResources.class.equals(annotationType)) {
                        return (A)this.ADD_SWAGGER_ANNOTATION;
                    }
                    return (A)annotatedType.getAnnotation(annotationType);
                }

                public Set<Annotation> getAnnotations() {
                    HashSet<Annotation> annotations = new HashSet<Annotation>(annotatedType.getAnnotations());
                    annotations.add(this.ADD_SWAGGER_ANNOTATION);
                    return annotations;
                }

                public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
                    return false;
                }
            });
        }
    }
}

