/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swarmtool;

import java.io.File;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.wildfly.swarm.arquillian.adapter.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.fractionlist.FractionDescriptor;
import org.wildfly.swarm.fractionlist.FractionList;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.PackageAnalyzer;

public class Build {
    static final Set<String> REQUIRED_FRACTIONS = new HashSet<String>(){
        {
            this.add("bootstrap");
            this.add("container");
        }
    };
    private final Set<String> swarmDependencies = new HashSet<String>();
    private File source;
    private File outputDir;
    private String name;
    private String version;
    private Properties properties;
    private boolean autoDetectFractions = true;

    public Build() {
        this.swarmDependencies.addAll(REQUIRED_FRACTIONS);
    }

    public Build source(File source) {
        this.source = source;
        return this;
    }

    public Build outputDir(File dir) {
        this.outputDir = dir;
        return this;
    }

    public Build properties(Properties props) {
        this.properties = props;
        return this;
    }

    public Build addSwarmDependencies(List<String> deps) {
        this.swarmDependencies.addAll(deps);
        return this;
    }

    public Build name(String name) {
        this.name = name;
        return this;
    }

    public Build swarmVersion(String v) {
        this.version = v;
        return this;
    }

    public Build autoDetectFractions(boolean v) {
        this.autoDetectFractions = v;
        return this;
    }

    private Set<String> allRequiredFractions() {
        FractionList fractionList = new FractionList();
        HashSet<String> fractions = new HashSet<String>();
        for (String fractionName : this.swarmDependencies) {
            fractions.add(fractionName);
            FractionDescriptor desc = fractionList.getFractionDescriptor("org.wildfly.swarm", fractionName);
            if (desc == null) continue;
            fractions.addAll(desc.getDependencies().stream().map(d -> d.getArtifactId()).collect(Collectors.toSet()));
        }
        return fractions;
    }

    public File run() throws Exception {
        String[] parts = this.source.getName().split("\\.(?=[^\\.]+$)");
        String baseName = parts[0];
        String type = parts[1] == null ? "jar" : parts[1];
        MavenRemoteRepository jbossPublic = MavenRemoteRepositories.createRemoteRepository((String)"jboss-public-repository-group", (String)"http://repository.jboss.org/nexus/content/groups/public/", (String)"default");
        jbossPublic.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
        jbossPublic.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
        ConfigurableMavenResolverSystem resolver = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(jbossPublic);
        BuildTool tool = new BuildTool().artifactResolvingHelper((ArtifactResolvingHelper)new ShrinkwrapArtifactResolvingHelper(resolver)).projectArtifact("", baseName, "", type, this.source).resolveTransitiveDependencies(true).properties(this.properties);
        if (this.autoDetectFractions) {
            this.swarmDependencies.addAll(new PackageAnalyzer(this.source).detectNeededFractions());
        } else {
            System.err.println("Skipping fraction auto-detection");
        }
        for (String dep : this.swarmDependencies) {
            tool.dependency("compile", "org.wildfly.swarm", dep, this.version, "jar", null, null);
        }
        String jarName = this.name != null ? this.name : baseName;
        String outDir = this.outputDir.getCanonicalPath();
        System.err.println(String.format("Building %s/%s-swarm.jar with fractions: %s", outDir, jarName, String.join((CharSequence)", ", this.allRequiredFractions().stream().sorted().collect(Collectors.toList()))));
        return tool.build(jarName, Paths.get(outDir, new String[0]));
    }
}

