/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swarmtool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.wildfly.swarm.swarmtool.Build;

public class Main {
    private static final OptionParser OPT_PARSER = new OptionParser();
    private static final OptionSpec<Void> HELP_OPT = OPT_PARSER.acceptsAll(Arrays.asList("h", "help"), "print help and exit").forHelp();
    private static final OptionSpec<Void> VERSION_OPT = OPT_PARSER.acceptsAll(Arrays.asList("v", "version"), "print version and exit").forHelp();
    private static final OptionSpec<Void> DISABLE_AUTO_DETECT = OPT_PARSER.accepts("no-fraction-detect", "disable auto fraction detection");
    private static final OptionSpec<String> FRACTIONS_OPT = OPT_PARSER.acceptsAll(Arrays.asList("f", "fractions"), "swarm fractions to include").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("undertow,jaxrs,...");
    private static final OptionSpec<String> OUTPUT_DIR_OPT = OPT_PARSER.acceptsAll(Arrays.asList("o", "output-dir"), "directory where the final jar will be written").withRequiredArg().ofType(String.class).defaultsTo((Object)".", (Object[])new String[0]).describedAs("path");
    private static final OptionSpec<String> NAME_OPT = OPT_PARSER.acceptsAll(Arrays.asList("n", "name"), "The name of the final jar sans the -swarm.jar suffix (default: <source name>)").withRequiredArg().ofType(String.class).describedAs("jar-name");
    private static final OptionSpec<File> SOURCE_OPT = OPT_PARSER.nonOptions("The source artifact").ofType(File.class);
    private static final OptionSpec<String> SYSPROPS_OPT = OPT_PARSER.accepts("D", "system property (overrides entry in --property-file)").withRequiredArg().ofType(String.class).describedAs("key=value");
    private static final OptionSpec<File> SYSPROPS_FILE_OPT = OPT_PARSER.accepts("property-file", "system properties").withRequiredArg().ofType(File.class).describedAs("system properties file");
    private static final String VERSION;

    public static void main(String[] args) throws Exception {
        try {
            Main.generateSwarmJar(args);
        }
        catch (ExitException e) {
            String msg = e.getMessage();
            if (msg != null) {
                System.err.println(msg);
            }
            System.exit(e.status);
        }
    }

    protected static File generateSwarmJar(String[] args) throws Exception {
        File source;
        List nonOptArgs;
        OptionSet foundOptions = null;
        try {
            foundOptions = OPT_PARSER.parse(args);
        }
        catch (OptionException e) {
            System.err.println(e.getMessage() + "\n");
        }
        if (foundOptions == null || foundOptions.has(HELP_OPT)) {
            OPT_PARSER.printHelpOn((OutputStream)System.err);
            Main.exit(null);
        }
        if (foundOptions.has(VERSION_OPT)) {
            Main.exit("swarmtool v" + VERSION, 0);
        }
        if ((nonOptArgs = foundOptions.valuesOf(SOURCE_OPT)).isEmpty()) {
            Main.exit("No source artifact specified.");
        }
        if (nonOptArgs.size() > 1) {
            Main.exit("Too many source artifacts provided (" + nonOptArgs + ")");
        }
        if (!(source = (File)nonOptArgs.get(0)).exists()) {
            Main.exit("File " + source.getAbsolutePath() + " does not exist.");
        }
        Properties properties = new Properties();
        if (foundOptions.has(SYSPROPS_FILE_OPT)) {
            try (FileInputStream in = new FileInputStream((File)foundOptions.valueOf(SYSPROPS_FILE_OPT));){
                properties.load(in);
            }
        }
        foundOptions.valuesOf(SYSPROPS_OPT).forEach(prop -> {
            String[] parts = prop.split("=");
            properties.put(parts[0], parts[1]);
        });
        return new Build().source(source).swarmVersion(VERSION).addSwarmDependencies(foundOptions.valuesOf(FRACTIONS_OPT)).outputDir(new File((String)foundOptions.valueOf(OUTPUT_DIR_OPT))).name((String)foundOptions.valueOf(NAME_OPT)).autoDetectFractions(!foundOptions.has(DISABLE_AUTO_DETECT)).properties(properties).run();
    }

    private static void exit(String message) {
        Main.exit(message, 1);
    }

    private static void exit(String message, int code) {
        throw new ExitException(code, message);
    }

    static {
        Properties props = new Properties();
        try (InputStream propStream = Main.class.getClassLoader().getResourceAsStream("org/wildfly/swarm/swarmtool/version.properties");){
            props.load(propStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VERSION = props.getProperty("version");
    }

    static class ExitException
    extends RuntimeException {
        public int status;

        ExitException(int status, String message) {
            super(message);
            this.status = status;
        }
    }
}

