/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.spi.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.DependenciesType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.DeploymentType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ExclusionsType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.JBossDeploymentStructureDescriptor;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ModuleDependencyType;
import org.jboss.shrinkwrap.descriptor.api.jbossdeployment13.ModuleExclusionType;
import org.wildfly.swarm.spi.api.ClassLoading;

public class JBossDeploymentStructureAsset
implements Asset {
    private final JBossDeploymentStructureDescriptor descriptor;

    public JBossDeploymentStructureAsset() {
        this.descriptor = ClassLoading.withTCCL(Descriptors.class.getClassLoader(), () -> Descriptors.create(JBossDeploymentStructureDescriptor.class));
    }

    public JBossDeploymentStructureAsset(InputStream fromStream) {
        this.descriptor = ClassLoading.withTCCL(Descriptors.class.getClassLoader(), () -> Descriptors.importAs(JBossDeploymentStructureDescriptor.class).fromStream(fromStream));
    }

    public void addModule(String name) {
        this.addModule(name, "main");
    }

    public void addModule(String name, String slot) {
        if (this.moduleExists(name, slot)) {
            return;
        }
        ModuleDependencyType<DependenciesType<DeploymentType<JBossDeploymentStructureDescriptor>>> d = this.descriptor.getOrCreateDeployment().getOrCreateDependencies().createModule().name(name).slot(slot);
    }

    public void addModule(String name, boolean export, String services) {
        this.addModule(name, "main", export, services, null);
    }

    public void addModule(String name, String slot, boolean export, String services, String metaInf) {
        if (this.moduleExists(name, slot, export, services)) {
            return;
        }
        ModuleDependencyType<DependenciesType<DeploymentType<JBossDeploymentStructureDescriptor>>> module = this.descriptor.getOrCreateDeployment().getOrCreateDependencies().createModule().name(name).slot(slot).export(export);
        if (services != null && services.length() > 0) {
            module.services(services);
        }
        if (metaInf != null && metaInf.length() > 0) {
            module.metaInf(metaInf);
        }
    }

    public void excludeModule(String name, String slot) {
        ExclusionsType<DeploymentType<JBossDeploymentStructureDescriptor>> exclusions = this.descriptor.getOrCreateDeployment().getOrCreateExclusions();
        List<ModuleExclusionType<ExclusionsType<DeploymentType<JBossDeploymentStructureDescriptor>>>> modules = exclusions.getAllModule();
        for (ModuleExclusionType<ExclusionsType<DeploymentType<JBossDeploymentStructureDescriptor>>> each : modules) {
            String existingSlot = each.getSlot();
            if (!name.equals(each.getName()) || !slot.equals(existingSlot == null ? "main" : existingSlot)) continue;
            return;
        }
        exclusions.createModule().name(name).slot(slot);
    }

    @Override
    public InputStream openStream() {
        String output = this.descriptor.exportAsString();
        return new ByteArrayInputStream(output.getBytes());
    }

    private boolean moduleExists(String name, String slot) {
        return this.findModules(name, slot).size() > 0;
    }

    private boolean moduleExists(String name, String slot, boolean export, String services) {
        return this.findModules(name, slot).stream().anyMatch(m -> m.isExport() == export && m.getServicesAsString().equals(services));
    }

    private List<ModuleDependencyType<DependenciesType<DeploymentType<JBossDeploymentStructureDescriptor>>>> findModules(String name, String slot) {
        return this.descriptor.getOrCreateDeployment().getOrCreateDependencies().getAllModule().stream().filter(m -> m.getName().equals(name) && m.getSlot().equals(slot)).collect(Collectors.toList());
    }
}

