/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swarmtool;

import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.fractionlist.FractionList;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.PropertiesUtil;

public class Main {
    private static final OptionParser OPT_PARSER = new OptionParser();
    private static final OptionSpec<Void> HELP_OPT = OPT_PARSER.acceptsAll(Arrays.asList("h", "help"), "print help and exit").forHelp();
    private static final OptionSpec<Void> VERSION_OPT = OPT_PARSER.acceptsAll(Arrays.asList("v", "version"), "print version and exit").forHelp();
    private static final OptionSpec<Void> DISABLE_AUTO_DETECT = OPT_PARSER.accepts("no-fraction-detect", "disable auto fraction detection");
    private static final OptionSpec<Void> DISABLE_BUNDLE_DEPS = OPT_PARSER.accepts("no-bundle-deps", "disable bundling of dependencies");
    private static final OptionSpec<String> FRACTIONS_OPT = OPT_PARSER.acceptsAll(Arrays.asList("f", "fractions"), "swarm fractions to include").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("undertow,jaxrs,...");
    private static final OptionSpec<String> OUTPUT_DIR_OPT = OPT_PARSER.acceptsAll(Arrays.asList("o", "output-dir"), "directory where the final jar will be written").withRequiredArg().ofType(String.class).defaultsTo(".", (String[])new String[0]).describedAs("path");
    private static final OptionSpec<String> NAME_OPT = OPT_PARSER.acceptsAll(Arrays.asList("n", "name"), "The name of the final jar sans the -swarm.jar suffix (default: <source name>)").withRequiredArg().ofType(String.class).describedAs("jar-name");
    private static final OptionSpec<File> SOURCE_OPT = OPT_PARSER.nonOptions("The source artifact").ofType(File.class);
    private static final OptionSpec<String> SYSPROPS_OPT = OPT_PARSER.accepts("D", "system property (overrides entry in --property-file)").withRequiredArg().ofType(String.class).describedAs("key=value");
    private static final OptionSpec<File> SYSPROPS_FILE_OPT = OPT_PARSER.accepts("property-file", "system properties").withRequiredArg().ofType(File.class).describedAs("system properties file");
    protected static final String VERSION;

    public static void main(String[] args) throws Exception {
        try {
            Main.generateSwarmJar(args);
        }
        catch (ExitException e) {
            String msg = e.getMessage();
            if (msg != null) {
                System.err.println(msg);
            }
            System.exit(e.status);
        }
    }

    protected static File generateSwarmJar(String[] args) throws Exception {
        File source;
        List<File> nonOptArgs;
        OptionSet foundOptions = null;
        try {
            foundOptions = OPT_PARSER.parse(args);
        }
        catch (OptionException e) {
            System.err.println(e.getMessage() + "\n");
        }
        if (foundOptions == null || foundOptions.has(HELP_OPT)) {
            OPT_PARSER.printHelpOn(System.err);
            Main.exit(null);
        }
        if (foundOptions.has(VERSION_OPT)) {
            Main.exit("swarmtool v" + VERSION, 0);
        }
        if ((nonOptArgs = foundOptions.valuesOf(SOURCE_OPT)).isEmpty()) {
            Main.exit("No source artifact specified.");
        }
        if (nonOptArgs.size() > 1) {
            Main.exit("Too many source artifacts provided (" + nonOptArgs + ")");
        }
        if (!(source = nonOptArgs.get(0)).exists()) {
            Main.exit("File " + source.getAbsolutePath() + " does not exist.");
        }
        Properties properties = new Properties();
        if (foundOptions.has(SYSPROPS_FILE_OPT)) {
            try (FileInputStream in = new FileInputStream(foundOptions.valueOf(SYSPROPS_FILE_OPT));){
                properties.load(in);
            }
        }
        foundOptions.valuesOf(SYSPROPS_OPT).forEach(prop -> {
            String[] parts = prop.split("=");
            properties.put(parts[0], parts[1]);
        });
        String[] parts = source.getName().split("\\.(?=[^\\.]+$)");
        String baseName = parts[0];
        String type = parts[1] == null ? "jar" : parts[1];
        String jarName = foundOptions.has(NAME_OPT) ? foundOptions.valueOf(NAME_OPT) : baseName;
        String outDir = new File(foundOptions.valueOf(OUTPUT_DIR_OPT)).getCanonicalPath();
        BuildTool tool = new BuildTool().artifactResolvingHelper(Main.getResolvingHelper()).projectArtifact("", baseName, "", type, source).fractionList(FractionList.get()).fractionDetectionMode(foundOptions.has(DISABLE_AUTO_DETECT) ? BuildTool.FractionDetectionMode.never : BuildTool.FractionDetectionMode.force).bundleDependencies(!foundOptions.has(DISABLE_BUNDLE_DEPS)).resolveTransitiveDependencies(true).properties(properties);
        Main.addSwarmFractions(tool, foundOptions.valuesOf(FRACTIONS_OPT));
        System.err.println(String.format("Building %s/%s-swarm.jar", outDir, jarName));
        return tool.build(jarName, Paths.get(outDir, new String[0]));
    }

    private static void exit(String message) {
        Main.exit(message, 1);
    }

    private static void exit(String message, int code) {
        throw new ExitException(code, message);
    }

    private static ArtifactResolvingHelper getResolvingHelper() {
        MavenRemoteRepository jbossPublic = MavenRemoteRepositories.createRemoteRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", "default");
        jbossPublic.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
        jbossPublic.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
        return new ShrinkwrapArtifactResolvingHelper((ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(jbossPublic));
    }

    private static void addSwarmFractions(BuildTool tool, List<String> deps) {
        deps.stream().map(f -> f.split(":")).map(parts -> ((String[])parts).length == 3 ? new FractionDescriptor(parts[0], parts[1], parts[2]) : new FractionDescriptor("org.wildfly.swarm", parts[0], parts[1])).forEach(f -> tool.fraction(f.toArtifactSpec()));
    }

    static {
        try {
            VERSION = PropertiesUtil.loadProperties(Main.class.getClassLoader().getResourceAsStream("org/wildfly/swarm/swarmtool/version.properties")).getProperty("version");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load version.properties", e);
        }
    }

    static class ExitException
    extends RuntimeException {
        public int status;

        ExitException(int status, String message) {
            super(message);
            this.status = status;
        }
    }
}

