/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmApplicationConf;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmBootstrapConf;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmClasspathConf;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmDependenciesConf;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildException;
import org.wildfly.swarm.tools.ModuleAnalyzer;
import org.wildfly.swarm.tools.ProjectAsset;

public class DependencyManager {
    public static final String WILDFLY_SWARM_GROUP_ID = "org.wildfly.swarm";
    public static final String WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID = "bootstrap";
    public static final String JBOSS_MODULES_GROUP_ID = "org.jboss.modules";
    public static final String JBOSS_MODULES_ARTIFACT_ID = "jboss-modules";
    private final Set<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> moduleDependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> bootstrapDependencies = new HashSet<ArtifactSpec>();
    private final Set<String> bootstrapModules = new HashSet<String>();
    private final Set<String> providedGAVs = new HashSet<String>();
    private final Map<String, String> providedGAVToModuleMappings = new HashMap<String, String>();
    private ArtifactResolvingHelper resolver;
    private WildFlySwarmClasspathConf classpathConf = new WildFlySwarmClasspathConf();

    public void setArtifactResolvingHelper(ArtifactResolvingHelper resolver) {
        this.resolver = resolver;
    }

    public void addDependency(ArtifactSpec dep) {
        this.dependencies.add(dep);
    }

    public void addAdditionalModule(Path module) {
        try {
            this.analyzeModuleDependencies(new ModuleAnalyzer(module));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean includeAsBootstrapJar(ArtifactSpec dependency) {
        if (dependency.scope.equals("TEST")) {
            return false;
        }
        if (this.isExplodedBootstrap(dependency)) {
            return false;
        }
        return !dependency.scope.equals("PROVIDED");
    }

    public boolean isExplodedBootstrap(ArtifactSpec dependency) {
        if (dependency.groupId().equals(JBOSS_MODULES_GROUP_ID) && dependency.artifactId().equals(JBOSS_MODULES_ARTIFACT_ID)) {
            return true;
        }
        return dependency.groupId().equals(WILDFLY_SWARM_GROUP_ID) && dependency.artifactId().equals(WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID);
    }

    public boolean isProvidedDependency(ArtifactSpec dependency) {
        String gav = dependency.groupId() + ":" + dependency.artifactId();
        return this.providedGAVs.contains(gav);
    }

    public ArtifactSpec findWildFlySwarmBootstrapJar() {
        return this.findArtifact(WILDFLY_SWARM_GROUP_ID, WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID, null, "jar", null);
    }

    public ArtifactSpec findJBossModulesJar() {
        return this.findArtifact(JBOSS_MODULES_GROUP_ID, JBOSS_MODULES_ARTIFACT_ID, null, "jar", null);
    }

    public ArtifactSpec findArtifact(String groupId, String artifactId, String version, String packaging, String classifier) {
        for (ArtifactSpec each : this.dependencies) {
            if (groupId != null && !groupId.equals(each.groupId()) || artifactId != null && !artifactId.equals(each.artifactId()) || version != null && !version.equals(each.version()) || packaging != null && !packaging.equals(each.type()) || classifier != null && !classifier.equals(each.classifier())) continue;
            return each;
        }
        return null;
    }

    public void populateUberJarMavenRepository(Archive archive) throws Exception {
        HashSet<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
        for (ArtifactSpec dependency : this.dependencies) {
            if (!this.bootstrapDependencies.contains(dependency) && !this.moduleDependencies.contains(dependency)) {
                dependency.shouldGather = false;
            }
            if (this.includeAsBootstrapJar(dependency)) {
                dependency.shouldGather = true;
            }
            if (this.isExplodedBootstrap(dependency)) {
                dependency.shouldGather = false;
            }
            if (this.isProvidedDependency(dependency)) {
                dependency.shouldGather = false;
            }
            if (!dependency.shouldGather) continue;
            dependencies.add(dependency);
        }
        for (ArtifactSpec dependency : this.moduleDependencies) {
            dependencies.add(dependency);
        }
        for (ArtifactSpec dependency : this.bootstrapDependencies) {
            if (this.isExplodedBootstrap(dependency)) continue;
            dependencies.add(dependency);
        }
        this.resolveAllArtifacts(dependencies);
        for (ArtifactSpec dependency : dependencies) {
            this.addArtifactToArchiveMavenRepository(archive, dependency);
        }
    }

    public void populateUserMavenRepository() throws Exception {
        this.resolveAllArtifacts(this.dependencies);
        for (ArtifactSpec each : this.moduleDependencies) {
            this.resolveArtifact(each);
        }
    }

    public void addArtifactToArchiveMavenRepository(Archive archive, ArtifactSpec artifact) throws Exception {
        if (artifact.gathered) {
            return;
        }
        artifact = this.resolveArtifact(artifact);
        StringBuilder artifactPath = new StringBuilder("m2repo/");
        artifactPath.append(artifact.repoPath(true));
        archive.add((Asset)new FileAsset(artifact.file), artifactPath.toString());
        artifact.gathered = true;
    }

    protected static Stream<ModuleAnalyzer> findModuleXmls(File file) {
        ArrayList<ModuleAnalyzer> analyzers = new ArrayList<ModuleAnalyzer>();
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry each = entries.nextElement();
                String name = each.getName();
                if (!name.startsWith("modules/") || !name.endsWith("module.xml")) continue;
                InputStream in = jar.getInputStream(each);
                analyzers.add(new ModuleAnalyzer(in));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return analyzers.stream();
    }

    Set<ArtifactSpec> getDependencies() {
        return this.dependencies;
    }

    Set<ArtifactSpec> getModuleDependencies() {
        return this.moduleDependencies;
    }

    Set<ArtifactSpec> getBootstrapDependencies() {
        return this.bootstrapDependencies;
    }

    Set<String> getBootstrapModules() {
        return this.bootstrapModules;
    }

    Set<String> getProvidedGAVs() {
        return this.providedGAVs;
    }

    Map<String, String> getProvidedGAVToModuleMappings() {
        return this.providedGAVToModuleMappings;
    }

    protected void analyzeDependencies(boolean resolveTransitive) throws Exception {
        if (resolveTransitive) {
            Set<ArtifactSpec> newDeps = this.resolveAllArtifacts(this.dependencies);
            this.dependencies.clear();
            this.dependencies.addAll(newDeps);
        } else {
            this.resolveAllArtifacts(this.dependencies);
        }
        this.scanModulesDependencies();
        this.scanBootstrapDependencies();
        this.analyzeModuleDependencies();
        this.analyzeProvidedDependencies();
    }

    protected void scanModulesDependencies() {
        this.dependencies.stream().filter(this::isModulesDependency).forEach(e -> this.bootstrapDependencies.add((ArtifactSpec)e));
    }

    protected void scanBootstrapDependencies() {
        this.dependencies.stream().filter(this::isBootstrapDependency).map(spec -> spec.file).forEach(this::scanBootstrapDependency);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isModulesDependency(ArtifactSpec spec) {
        if (spec.file == null) {
            return false;
        }
        if (!spec.type().equals("jar")) {
            return false;
        }
        if (spec.groupId().equals(WILDFLY_SWARM_GROUP_ID) && spec.artifactId().equals(WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID)) {
            return true;
        }
        try (JarFile jar = new JarFile(spec.file);){
            String name;
            Enumeration<JarEntry> entries = jar.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while (!(name = entries.nextElement().getName()).startsWith("modules/") || !name.endsWith("module.xml"));
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isBootstrapDependency(ArtifactSpec spec) {
        if (spec.file == null) {
            return false;
        }
        if (!spec.type().equals("jar")) {
            return false;
        }
        try (JarFile jar = new JarFile(spec.file);){
            ZipEntry entry = jar.getEntry("wildfly-swarm-bootstrap.conf");
            if (entry != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!spec.groupId().equals(WILDFLY_SWARM_GROUP_ID)) return false;
        if (!spec.artifactId().equals(WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID)) return false;
        return true;
    }

    protected void scanBootstrapDependency(File file) {
        block27: {
            try (JarFile jar = new JarFile(file);){
                ZipEntry entry = jar.getEntry("wildfly-swarm-bootstrap.conf");
                if (entry == null) break block27;
                try (InputStream in = jar.getInputStream(entry);){
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty()) continue;
                        this.bootstrapModules.add(line);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected WildFlySwarmBootstrapConf getWildFlySwarmBootstrapConf() {
        WildFlySwarmBootstrapConf bootstrapConf = new WildFlySwarmBootstrapConf();
        for (ArtifactSpec each : this.bootstrapDependencies) {
            if (this.isExplodedBootstrap(each)) continue;
            bootstrapConf.addEntry(each);
        }
        return bootstrapConf;
    }

    protected WildFlySwarmApplicationConf getWildFlySwarmApplicationConf(ProjectAsset projectAsset) {
        HashSet<ArtifactSpec> applicationArtifacts = new HashSet<ArtifactSpec>();
        WildFlySwarmApplicationConf appConf = new WildFlySwarmApplicationConf();
        for (ArtifactSpec artifactSpec : this.dependencies) {
            if (this.bootstrapDependencies.contains(artifactSpec) || !artifactSpec.type().equals("jar") || !artifactSpec.shouldGather) continue;
            Set actions = this.classpathConf.getActions(artifactSpec.file, artifactSpec.groupId(), artifactSpec.artifactId()).stream().filter(a -> a instanceof WildFlySwarmClasspathConf.ReplaceAction).collect(Collectors.toSet());
            if (actions.isEmpty()) {
                if (this.isProvidedDependency(artifactSpec)) continue;
                applicationArtifacts.add(artifactSpec);
                continue;
            }
            if (!this.includeAsBootstrapJar(artifactSpec)) continue;
            for (WildFlySwarmClasspathConf.Action action : actions) {
                WildFlySwarmClasspathConf.ReplaceAction replace = (WildFlySwarmClasspathConf.ReplaceAction)action;
                appConf.addEntry(new WildFlySwarmApplicationConf.ModuleEntry(replace.moduleName + ":" + replace.moduleSlot));
            }
        }
        for (String string : this.bootstrapModules) {
            appConf.addEntry(new WildFlySwarmApplicationConf.ModuleEntry(string));
        }
        for (ArtifactSpec artifactSpec : applicationArtifacts) {
            String mapped = this.providedGAVToModuleMappings.get(artifactSpec.groupId() + ":" + artifactSpec.artifactId());
            if (mapped != null) {
                appConf.addEntry(new WildFlySwarmApplicationConf.ModuleEntry(mapped));
                continue;
            }
            if (!this.includeAsBootstrapJar(artifactSpec)) continue;
            artifactSpec.shouldGather = true;
            appConf.addEntry(new WildFlySwarmApplicationConf.GAVEntry(artifactSpec));
        }
        appConf.addEntry(new WildFlySwarmApplicationConf.PathEntry(projectAsset.getName()));
        return appConf;
    }

    protected WildFlySwarmDependenciesConf getWildFlySwarmDependenciesConf() {
        WildFlySwarmDependenciesConf depsConf = new WildFlySwarmDependenciesConf();
        for (ArtifactSpec each : this.dependencies) {
            if (this.providedGAVs.contains(each.groupId() + ":" + each.artifactId()) || !each.scope.equalsIgnoreCase("compile")) continue;
            if (each.type().equals("jar")) {
                depsConf.addPrimaryDependency(each);
                continue;
            }
            depsConf.addExtraDependency(each);
        }
        return depsConf;
    }

    protected void analyzeModuleDependencies() {
        this.bootstrapDependencies.stream().filter(e -> e.type().equals("jar")).map(e -> e.file).flatMap(DependencyManager::findModuleXmls).forEach(this::analyzeModuleDependencies);
    }

    protected void analyzeModuleDependencies(ModuleAnalyzer analyzer) {
        this.moduleDependencies.addAll(analyzer.getDependencies());
        for (ArtifactSpec each : analyzer.getDependencies()) {
            if (analyzer.getName().startsWith(WILDFLY_SWARM_GROUP_ID) && analyzer.getSlot().equals("api")) {
                this.providedGAVs.add(each.groupId() + ":" + each.artifactId());
                this.providedGAVs.add(each.groupId() + ":" + each.artifactId().substring(0, each.artifactId().length() - "-api".length()));
                continue;
            }
            this.providedGAVToModuleMappings.put(each.groupId() + ":" + each.artifactId(), analyzer.getName() + ":" + analyzer.getSlot());
        }
    }

    protected void analyzeProvidedDependencies() {
        this.dependencies.stream().filter(e -> e.type().equals("jar")).forEach(this::analyzeProvidedDependencies);
    }

    protected void analyzeProvidedDependencies(ArtifactSpec spec) {
        if (spec.file == null) {
            return;
        }
        try (JarFile jar = new JarFile(spec.file);){
            ZipEntry entry = jar.getEntry("META-INF/wildfly-swarm-classpath.conf");
            if (entry != null) {
                this.classpathConf.read(jar.getInputStream(entry));
                this.providedGAVs.add(spec.groupId() + ":" + spec.artifactId());
                if (spec.artifactId().endsWith("-modules")) {
                    this.providedGAVs.add(spec.groupId() + ":" + spec.artifactId().substring(0, spec.artifactId().length() - "-modules".length()) + "-api");
                }
                if (spec.artifactId().endsWith("-api")) {
                    this.providedGAVs.add(spec.groupId() + ":" + spec.artifactId().substring(0, spec.artifactId().length() - "-api".length()));
                }
                this.providedGAVs.addAll(this.classpathConf.getMatchesForActionType(WildFlySwarmClasspathConf.MavenMatcher.class, WildFlySwarmClasspathConf.RemoveAction.class).stream().map(m -> (WildFlySwarmClasspathConf.MavenMatcher)m).map(m -> m.groupId + ":" + m.artifactId).collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected ArtifactSpec resolveArtifact(ArtifactSpec spec) throws Exception {
        if (spec.file == null) {
            ArtifactSpec newArtifact = this.resolver.resolve(spec);
            if (newArtifact == null) {
                throw new BuildException("Unable to resolve artifact: " + spec);
            }
            spec.file = newArtifact.file;
        }
        return spec;
    }

    protected Set<ArtifactSpec> resolveAllArtifacts(Set<ArtifactSpec> specs) throws Exception {
        return this.resolver.resolveAll(specs);
    }
}

