/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.FractionList;
import org.wildfly.swarm.tools.PackageDetector;

public class FractionUsageAnalyzer {
    private final List<File> sources = new ArrayList<File>();
    private final FractionList fractionList;

    public FractionUsageAnalyzer(FractionList fractionList) {
        this.fractionList = fractionList;
    }

    public FractionUsageAnalyzer source(Path source) {
        this.source(source.toFile());
        return this;
    }

    public FractionUsageAnalyzer source(File source) {
        this.sources.add(source);
        return this;
    }

    public Set<FractionDescriptor> detectNeededFractions() throws IOException {
        if (this.fractionList == null) {
            return Collections.emptySet();
        }
        HashSet<FractionDescriptor> specs = new HashSet<FractionDescriptor>();
        for (File f : this.sources) {
            specs.addAll(this.findFractions(PackageDetector.detectPackages(f).keySet()));
        }
        Iterator it = specs.iterator();
        while (it.hasNext()) {
            FractionDescriptor descriptor = (FractionDescriptor)it.next();
            if (!specs.stream().anyMatch(fd -> fd.getDependencies().contains(descriptor))) continue;
            it.remove();
        }
        if (specs.isEmpty()) {
            specs.add(this.fractionList.getFractionDescriptor("org.wildfly.swarm", "container"));
        }
        return specs;
    }

    protected Set<FractionDescriptor> findFractions(Set<String> packages) {
        List<StatefulPackageMatcher> fractionPackages = this.fractionMatchers();
        return packages.stream().flatMap(p -> fractionPackages.stream().map(m -> m.fraction((String)p))).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private List<StatefulPackageMatcher> fractionMatchers() {
        ArrayList<StatefulPackageMatcher> matchers = new ArrayList<StatefulPackageMatcher>();
        this.fractionList.getPackageSpecs().forEach((spec, fd) -> Stream.of(spec.split(",")).forEach(s -> matchers.add(new StatefulPackageMatcher((FractionDescriptor)fd, s.split("\\+")))));
        return matchers;
    }

    private static class StatefulPackageMatcher {
        private final FractionDescriptor descriptor;
        private final Set<String> packageSpecs;
        private final Set<String> matchedPackages = new HashSet<String>();

        StatefulPackageMatcher(FractionDescriptor desc, String ... packages) {
            this.descriptor = desc;
            this.packageSpecs = new HashSet<String>(Arrays.asList(packages));
        }

        public FractionDescriptor fraction(String pkg) {
            String match = this.matchingSpec(pkg);
            if (match != null) {
                this.matchedPackages.add(match);
            }
            return this.matchedPackages.equals(this.packageSpecs) ? this.descriptor : null;
        }

        private String matchingSpec(String pkg) {
            return this.packageSpecs.stream().filter(spec -> {
                if (spec.endsWith("*")) {
                    return pkg.startsWith(spec.substring(0, spec.length() - 1));
                }
                return pkg.equals(spec);
            }).findFirst().orElse(null);
        }
    }
}

