/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class PackageDetector {
    public static Map<String, Set<String>> detectPackages(File file) throws IOException {
        PackageCollector visitor = new PackageCollector();
        return PackageDetector.detectPackages(file, visitor);
    }

    protected static Map<String, Set<String>> detectPackages(File file, PackageCollector visitor) throws IOException {
        if (file.isDirectory()) {
            return PackageDetector.detectPackagesInDir(file, visitor);
        }
        if (file.getName().endsWith(".jar") || file.getName().endsWith(".war")) {
            return PackageDetector.detectPackagesInZip(new ZipFile(file), visitor);
        }
        return Collections.emptyMap();
    }

    protected static Map<String, Set<String>> detectPackagesInZip(ZipFile file, PackageCollector visitor) throws IOException {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.endsWith(".jar")) {
                File jarFile = File.createTempFile("swarmPackageDetector", ".jar");
                jarFile.deleteOnExit();
                try (InputStream in = file.getInputStream(entry);
                     FileOutputStream out = new FileOutputStream(jarFile);){
                    IOUtils.copy(in, (OutputStream)out);
                }
                PackageDetector.detectPackagesInZip(new ZipFile(jarFile), visitor);
                continue;
            }
            if (!name.endsWith(".class")) continue;
            InputStream in = file.getInputStream(entry);
            Throwable throwable = null;
            try {
                new ClassReader(in).accept(visitor, 0);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        return visitor.packageSources();
    }

    protected static Map<String, Set<String>> detectPackagesInDir(File dir, PackageCollector visitor) throws IOException {
        File[] entries;
        for (File entry : entries = dir.listFiles()) {
            String name = entry.getName();
            if (name.endsWith(".class")) {
                try (FileInputStream in = new FileInputStream(entry);){
                    new ClassReader(in).accept(visitor, 0);
                    continue;
                }
            }
            PackageDetector.detectPackages(entry, visitor);
        }
        return visitor.packageSources();
    }

    static class PackageCollector
    extends ClassVisitor {
        private final Map<String, Set<String>> packages = new HashMap<String, Set<String>>();
        private String currentClass = null;
        private final AnnotationVisitor ANNOTATION_VISITOR = new AnnotationVisitor(327680){

            @Override
            public void visit(String __, Object value) {
                if (value instanceof Type) {
                    this.addType((Type)value);
                }
            }

            @Override
            public void visitEnum(String __, String desc, String ___) {
                this.addType(desc);
            }

            @Override
            public AnnotationVisitor visitAnnotation(String __, String desc) {
                this.addType(desc);
                return this;
            }

            @Override
            public AnnotationVisitor visitArray(String __) {
                return this;
            }
        };
        private final SignatureVisitor SIGNATURE_VISITOR = new SignatureVisitor(327680){
            private String outerName;

            @Override
            public void visitClassType(String name) {
                this.outerName = name;
                this.addInternalType(name);
            }

            @Override
            public void visitInnerClassType(String name) {
                this.outerName = this.outerName + "$" + name;
                this.addInternalType(this.outerName);
            }
        };

        public PackageCollector() {
            super(327680);
        }

        public Set<String> packages() {
            return Collections.unmodifiableSet(this.packages.keySet());
        }

        public Map<String, Set<String>> packageSources() {
            return Collections.unmodifiableMap(this.packages);
        }

        @Override
        public void visit(int __, int ___, String name, String signature, String superName, String[] interfaces) {
            this.currentClass = name.replace('/', '.');
            this.addPackage(name);
            if (signature == null) {
                if (superName != null) {
                    this.addInternalType(superName);
                }
                this.addInternalTypes(interfaces);
            } else {
                this.addSignature(signature);
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean __) {
            this.addType(desc);
            return new AnnotationVisitor(327680){

                @Override
                public void visit(String __, Object value) {
                    if (value instanceof Type) {
                        this.addType((Type)value);
                    }
                }

                @Override
                public void visitEnum(String __, String desc, String ___) {
                    this.addType(desc);
                }

                @Override
                public AnnotationVisitor visitAnnotation(String __, String desc) {
                    this.addType(desc);
                    return this;
                }

                @Override
                public AnnotationVisitor visitArray(String __) {
                    return this;
                }
            };
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int __, TypePath ___, String desc, boolean ____) {
            this.addType(desc);
            return this.ANNOTATION_VISITOR;
        }

        @Override
        public FieldVisitor visitField(int __, String ___, String desc, String signature, Object value) {
            if (value instanceof Type) {
                this.addType((Type)value);
            }
            if (signature != null) {
                this.addTypeSignature(signature);
            } else {
                this.addType(desc);
            }
            return new FieldVisitor(327680){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean __) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }
            };
        }

        @Override
        public MethodVisitor visitMethod(int __, String ___, String desc, String signature, String[] exceptions) {
            if (signature != null) {
                this.addSignature(signature);
            } else {
                this.addMethodTypes(desc);
            }
            this.addInternalTypes(exceptions);
            return new MethodVisitor(327680){

                @Override
                public AnnotationVisitor visitAnnotationDefault() {
                    return ANNOTATION_VISITOR;
                }

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean __) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                @Override
                public AnnotationVisitor visitTypeAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int __, String desc, boolean ___) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                @Override
                public void visitTypeInsn(int __, String type) {
                    this.addType(Type.getObjectType(type));
                }

                @Override
                public void visitFieldInsn(int __, String owner, String ___, String desc) {
                    this.addInternalType(owner);
                    this.addType(desc);
                }

                @Override
                public void visitMethodInsn(int __, String owner, String ___, String desc, boolean ____) {
                    this.addInternalType(owner);
                    this.addMethodTypes(desc);
                }

                @Override
                public void visitInvokeDynamicInsn(String __, String desc, Handle bsm, Object ... bsmArgs) {
                    this.addMethodTypes(desc);
                    this.addConstant(bsm);
                    for (Object each : bsmArgs) {
                        this.addConstant(each);
                    }
                }

                @Override
                public void visitLdcInsn(Object cst) {
                    this.addConstant(cst);
                }

                @Override
                public void visitMultiANewArrayInsn(String desc, int __) {
                    this.addType(desc);
                }

                @Override
                public AnnotationVisitor visitInsnAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                @Override
                public void visitLocalVariable(String __, String ___, String signature, Label ____, Label _____, int ______) {
                    this.addTypeSignature(signature);
                }

                @Override
                public AnnotationVisitor visitLocalVariableAnnotation(int __, TypePath ___, Label[] ____, Label[] _____, int[] ______, String desc, boolean _______) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }

                @Override
                public void visitTryCatchBlock(Label __, Label ____, Label _____, String type) {
                    if (type != null) {
                        this.addInternalType(type);
                    }
                }

                @Override
                public AnnotationVisitor visitTryCatchAnnotation(int __, TypePath ___, String desc, boolean ____) {
                    this.addType(desc);
                    return ANNOTATION_VISITOR;
                }
            };
        }

        private String addPackage(String name) {
            if (name != null) {
                Set<String> sources;
                int pos = name.lastIndexOf(47);
                if (pos > -1) {
                    name = name.substring(0, pos);
                }
                if ((sources = this.packages.get(name = name.replace('/', '.'))) == null) {
                    sources = new HashSet<String>();
                    this.packages.put(name, sources);
                }
                sources.add(this.currentClass);
            }
            return name;
        }

        private void addType(Type type) {
            switch (type.getSort()) {
                case 9: {
                    this.addType(type.getElementType());
                    break;
                }
                case 10: {
                    this.addPackage(type.getInternalName());
                    break;
                }
                case 11: {
                    this.addMethodTypes(type.getDescriptor());
                }
            }
        }

        private void addType(String desc) {
            this.addType(Type.getType(desc));
        }

        private void addInternalType(String name) {
            this.addType(Type.getObjectType(name));
        }

        private void addInternalTypes(String[] names) {
            if (names != null) {
                for (String each : names) {
                    if (each == null) continue;
                    this.addInternalType(each);
                }
            }
        }

        private void addMethodTypes(String desc) {
            this.addType(Type.getReturnType(desc));
            for (Type each : Type.getArgumentTypes(desc)) {
                this.addType(each);
            }
        }

        private void addSignature(String signature) {
            if (signature != null) {
                new SignatureReader(signature).accept(this.SIGNATURE_VISITOR);
            }
        }

        void addTypeSignature(String signature) {
            if (signature != null) {
                new SignatureReader(signature).acceptType(this.SIGNATURE_VISITOR);
            }
        }

        void addConstant(Object constant) {
            if (constant instanceof Type) {
                this.addType((Type)constant);
            } else if (constant instanceof Handle) {
                Handle handle = (Handle)constant;
                this.addInternalType(handle.getOwner());
                this.addMethodTypes(handle.getDesc());
            }
        }
    }
}

