/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools.exec;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.wildfly.swarm.tools.exec.IOBridge;

public class SwarmProcess {
    private final Process process;
    private final IOBridge stdout;
    private final IOBridge stderr;
    private final CountDownLatch latch;

    public SwarmProcess(Process process, OutputStream stdout, Path stdoutFile, OutputStream stderr, Path stderrFile) throws IOException {
        this.process = process;
        this.latch = new CountDownLatch(1);
        this.stdout = new IOBridge(this.latch, process.getInputStream(), stdout, stdoutFile);
        this.stderr = new IOBridge(this.latch, process.getErrorStream(), stderr, stderrFile);
        new Thread(this.stdout).start();
        new Thread(this.stderr).start();
    }

    public Exception getError() {
        if (this.stdout.getError() != null) {
            return this.stdout.getError();
        }
        if (this.stderr.getError() != null) {
            return this.stderr.getError();
        }
        return null;
    }

    public OutputStream getOutputStream() {
        return this.process.getOutputStream();
    }

    public void destroy() {
        this.process.destroy();
    }

    public boolean isAlive() {
        return this.process.isAlive();
    }

    public Process destroyForcibly() {
        return this.process.destroyForcibly();
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
        return this.process.waitFor(timeout, unit);
    }

    public int exitValue() {
        return this.process.exitValue();
    }

    public void awaitDeploy(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.latch.await(timeout, timeUnit);
    }

    public int stop() throws InterruptedException {
        return this.stop(10L, TimeUnit.SECONDS);
    }

    public int stop(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this.process.destroy();
        if (!this.process.waitFor(timeout, timeUnit)) {
            this.process.destroyForcibly();
        }
        try {
            this.stdout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stderr.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!this.process.isAlive()) {
            return this.process.exitValue();
        }
        return -1;
    }
}

