/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer.zip;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipImporterImpl
extends AssignableBase<Archive<?>>
implements ZipImporter {
    private static final Logger log = Logger.getLogger(ZipImporterImpl.class.getName());

    public ZipImporterImpl(Archive<?> archive) {
        super(archive);
    }

    @Override
    @Deprecated
    public ZipImporter importZip(ZipInputStream stream) {
        return this.importFrom(stream);
    }

    @Override
    @Deprecated
    public ZipImporter importZip(ZipFile file) {
        return this.importFrom(file);
    }

    @Override
    public ZipImporter importFrom(InputStream stream) throws ArchiveImportException {
        Validate.notNull(stream, "Stream must be specified");
        try {
            ZipEntry entry;
            ZipInputStream zipStream = new ZipInputStream(stream);
            while ((entry = zipStream.getNextEntry()) != null) {
                String entryName = entry.getName();
                Object archive = this.getArchive();
                if (entry.isDirectory()) {
                    archive.addAsDirectory(entryName);
                    continue;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream(8192);
                IOUtil.copy(zipStream, output);
                archive.add((Asset)new ByteArrayAsset(output.toByteArray()), entryName);
                zipStream.closeEntry();
            }
        }
        catch (IOException e) {
            throw new ArchiveImportException("Could not import stream", e);
        }
        return this;
    }

    @Override
    public ZipImporter importFrom(File file) throws ArchiveImportException {
        ZipFile zipFile;
        Validate.notNull(file, "File must be specified");
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File to import as ZIP must not be a directory: " + file.getAbsolutePath());
        }
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new ArchiveImportException("Could not obtain ZIP File from File", ioe);
        }
        return this.importFrom(zipFile);
    }

    @Override
    public ZipImporter importFrom(ZipFile file) throws ArchiveImportException {
        Validate.notNull(file, "File must be specified");
        try {
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                Object archive = this.getArchive();
                if (entry.isDirectory()) {
                    archive.addAsDirectory(entryName);
                    continue;
                }
                archive.add((Asset)new ZipFileEntryAsset(file, entry), new BasicPath(entryName));
            }
        }
        catch (Exception e) {
            throw new ArchiveImportException("Could not import file", e);
        }
        return this;
    }
}

