/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ZipFileEntryAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmApplicationConf;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmBootstrapConf;
import org.wildfly.swarm.bootstrap.util.WildFlySwarmDependenciesConf;
import org.wildfly.swarm.tools.ArchiveAsset;
import org.wildfly.swarm.tools.ArtifactAsset;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DependencyManager;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.FractionList;
import org.wildfly.swarm.tools.FractionUsageAnalyzer;
import org.wildfly.swarm.tools.ProjectAsset;
import org.wildfly.swarm.tools.UberJarManifestAsset;

public class BuildTool {
    private final Set<ArtifactSpec> fractions = new HashSet<ArtifactSpec>();
    private final JavaArchive archive;
    private final Set<String> resourceDirectories = new HashSet<String>();
    private String mainClass;
    private boolean bundleDependencies = true;
    private boolean resolveTransitiveDependencies = false;
    private boolean executable;
    private File executableScript;
    private DependencyManager dependencyManager = new DependencyManager();
    private ProjectAsset projectAsset;
    private Properties properties = new Properties();
    private Set<String> additionalModules = new HashSet<String>();
    private FractionDetectionMode fractionDetectionMode = FractionDetectionMode.when_missing;
    private FractionList fractionList = null;
    private SimpleLogger log = STD_LOGGER;
    private static SimpleLogger STD_LOGGER = new SimpleLogger(){

        @Override
        public void info(String msg) {
            System.out.println(msg);
        }

        @Override
        public void error(String msg) {
            System.err.println(msg);
        }

        @Override
        public void error(String msg, Throwable t) {
            this.error(msg);
            t.printStackTrace();
        }
    };

    public BuildTool() {
        this.archive = ShrinkWrap.create(JavaArchive.class);
    }

    public BuildTool mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public BuildTool properties(Properties properties) {
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public BuildTool bundleDependencies(boolean bundleDependencies) {
        this.bundleDependencies = bundleDependencies;
        return this;
    }

    public BuildTool resolveTransitiveDependencies(boolean resolveTransitiveDependencies) {
        this.resolveTransitiveDependencies = resolveTransitiveDependencies;
        return this;
    }

    public BuildTool projectArtifact(String groupId, String artifactId, String version, String packaging, File file) {
        this.projectArtifact(groupId, artifactId, version, packaging, file, null);
        return this;
    }

    public BuildTool projectArtifact(String groupId, String artifactId, String version, String packaging, File file, String artifactName) {
        this.projectAsset = new ArtifactAsset(new ArtifactSpec(null, groupId, artifactId, version, packaging, null, file), artifactName);
        return this;
    }

    public BuildTool projectArchive(Archive archive) {
        this.projectAsset = new ArchiveAsset(archive);
        return this;
    }

    public BuildTool fraction(ArtifactSpec spec) {
        this.fractions.add(spec);
        return this;
    }

    public BuildTool dependency(String scope, String groupId, String artifactId, String version, String packaging, String classifier, File file) {
        this.dependency(new ArtifactSpec(scope, groupId, artifactId, version, packaging, classifier, file));
        return this;
    }

    public BuildTool dependency(ArtifactSpec spec) {
        this.dependencyManager.addDependency(spec);
        return this;
    }

    public BuildTool additionalModule(String module) {
        this.additionalModules.add(module);
        return this;
    }

    public BuildTool additionalModules(Collection<String> modules) {
        this.additionalModules.addAll(modules);
        return this;
    }

    public BuildTool artifactResolvingHelper(ArtifactResolvingHelper resolver) {
        this.dependencyManager.setArtifactResolvingHelper(resolver);
        return this;
    }

    public BuildTool resourceDirectory(String dir) {
        this.resourceDirectories.add(dir);
        return this;
    }

    public BuildTool fractionList(FractionList v) {
        this.fractionList = v;
        return this;
    }

    public BuildTool fractionDetectionMode(FractionDetectionMode v) {
        this.fractionDetectionMode = v;
        return this;
    }

    public BuildTool executable(boolean executable) {
        this.executable = executable;
        return this;
    }

    public BuildTool executableScript(File executableScript) {
        this.executableScript = executableScript;
        return this;
    }

    public BuildTool logger(SimpleLogger logger) {
        this.log = logger;
        return this;
    }

    public File build(String baseName, Path dir) throws Exception {
        this.build();
        return this.createJar(baseName, dir);
    }

    public Archive build() throws Exception {
        this.analyzeDependencies();
        this.addWildflySwarmBootstrapJar();
        this.addWildFlyBootstrapConf();
        this.addManifest();
        this.addWildFlySwarmProperties();
        this.addWildFlySwarmApplicationConf();
        this.addWildFlySwarmDependenciesConf();
        this.addAdditionalModules();
        this.addProjectAsset();
        this.populateUberJarMavenRepository();
        return this.archive;
    }

    public boolean bootstrapJarShadesJBossModules(File artifactFile) throws IOException {
        JarFile jarFile = new JarFile(artifactFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        boolean jbossModulesFound = false;
        while (entries.hasMoreElements()) {
            JarEntry each = entries.nextElement();
            if (!each.getName().startsWith("org/jboss/modules/ModuleLoader")) continue;
            jbossModulesFound = true;
        }
        return jbossModulesFound;
    }

    public void expandArtifact(File artifactFile) throws IOException {
        JarFile jarFile = new JarFile(artifactFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry each = entries.nextElement();
            if (each.getName().startsWith("META-INF") || each.isDirectory()) continue;
            this.archive.add((Asset)new ZipFileEntryAsset(jarFile, each), each.getName());
        }
    }

    protected void analyzeDependencies() throws Exception {
        this.dependencyManager.analyzeDependencies(this.resolveTransitiveDependencies);
    }

    private void addProjectAsset() {
        this.archive.add(this.projectAsset);
    }

    private boolean detectFractions() throws Exception {
        File tmpFile = File.createTempFile("buildtool", this.projectAsset.getName().replace("/", "_"));
        tmpFile.deleteOnExit();
        this.projectAsset.getArchive().as(ZipExporter.class).exportTo(tmpFile, true);
        FractionUsageAnalyzer analyzer = new FractionUsageAnalyzer(this.fractionList).source(tmpFile);
        this.dependencyManager.getDependencies().stream().filter(d -> !"provided".equals(d.scope) && !"test".equals(d.scope)).forEach(d -> analyzer.source(d.file));
        Set<FractionDescriptor> detectedFractions = analyzer.detectNeededFractions();
        detectedFractions.removeAll(this.fractions.stream().map(x -> FractionDescriptor.fromArtifactSpec(x)).collect(Collectors.toSet()));
        this.log.info(String.format("Detected %sfractions: %s", this.fractions.isEmpty() ? "" : "additional ", String.join((CharSequence)", ", detectedFractions.stream().map(FractionDescriptor::av).sorted().collect(Collectors.toList()))));
        detectedFractions.stream().map(FractionDescriptor::toArtifactSpec).forEach(this::fraction);
        return !detectedFractions.isEmpty();
    }

    static String strippedSwarmGav(MavenArtifactDescriptor desc) {
        if (desc.groupId().equals("org.wildfly.swarm")) {
            return String.format("%s:%s", desc.artifactId(), desc.version());
        }
        return desc.mscGav();
    }

    private void addFractions() throws Exception {
        HashSet<ArtifactSpec> allFractions = new HashSet<ArtifactSpec>(this.fractions);
        this.fractions.stream().flatMap(s -> this.fractionList.getFractionDescriptor(s.groupId(), s.artifactId()).getDependencies().stream().map(FractionDescriptor::toArtifactSpec)).filter(d -> this.dependencyManager.findArtifact(d.groupId(), d.artifactId(), null, null, null) == null).forEach(allFractions::add);
        this.log.info("Adding fractions: " + String.join((CharSequence)", ", allFractions.stream().map(BuildTool::strippedSwarmGav).sorted().collect(Collectors.toList())));
        allFractions.forEach(f -> this.dependencyManager.addDependency((ArtifactSpec)f));
        this.resolveTransitiveDependencies(true);
        this.analyzeDependencies();
    }

    private void addWildflySwarmBootstrapJar() throws Exception {
        ArtifactSpec artifact = this.dependencyManager.findWildFlySwarmBootstrapJar();
        if (!this.fractions.isEmpty()) {
            this.addFractions();
        }
        if (this.fractionDetectionMode != FractionDetectionMode.never) {
            if (this.fractionList == null) {
                throw new IllegalStateException("Fraction detection requested, but no FractionList provided");
            }
            if (this.fractionDetectionMode == FractionDetectionMode.force || artifact == null) {
                this.log.info("Scanning for needed WildFly Swarm fractions with mode: " + (Object)((Object)this.fractionDetectionMode));
                if (this.detectFractions()) {
                    this.addFractions();
                }
            }
        }
        artifact = this.dependencyManager.findWildFlySwarmBootstrapJar();
        if (this.fractionDetectionMode == FractionDetectionMode.never && artifact == null) {
            this.log.error("No WildFly Swarm dependencies found and fraction detection disabled");
        }
        if (artifact != null) {
            if (!this.bootstrapJarShadesJBossModules(artifact.file)) {
                ArtifactSpec jbossModules = this.dependencyManager.findJBossModulesJar();
                this.expandArtifact(jbossModules.file);
            }
        } else {
            throw new IllegalStateException("No WildFly Swarm Bootstrap fraction found");
        }
        this.expandArtifact(artifact.file);
    }

    private void addManifest() throws IOException {
        UberJarManifestAsset manifest = new UberJarManifestAsset(this.mainClass);
        this.archive.add(manifest);
    }

    private void addWildFlySwarmProperties() throws IOException {
        Properties props = new Properties();
        Enumeration<?> propNames = this.properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String eachName = (String)propNames.nextElement();
            String eachValue = this.properties.get(eachName).toString();
            props.put(eachName, eachValue);
        }
        props.setProperty("swarm.app.artifact", this.projectAsset.getSimpleName());
        if (this.bundleDependencies) {
            props.setProperty("swarm.bundled.dependencies", "true");
        }
        ByteArrayOutputStream propsBytes = new ByteArrayOutputStream();
        props.store(propsBytes, "Generated by WildFly Swarm");
        this.archive.addAsManifestResource((Asset)new ByteArrayAsset(propsBytes.toByteArray()), "wildfly-swarm.properties");
    }

    private void addWildFlyBootstrapConf() throws Exception {
        WildFlySwarmBootstrapConf bootstrapConf = this.dependencyManager.getWildFlySwarmBootstrapConf();
        this.archive.add((Asset)new StringAsset(bootstrapConf.toString()), "META-INF/wildfly-swarm-bootstrap.conf");
    }

    private void addWildFlySwarmDependenciesConf() throws IOException {
        WildFlySwarmDependenciesConf depsConf = this.dependencyManager.getWildFlySwarmDependenciesConf();
        this.archive.add((Asset)new StringAsset(depsConf.toString()), "META-INF/wildfly-swarm-dependencies.conf");
    }

    private void addWildFlySwarmApplicationConf() throws Exception {
        WildFlySwarmApplicationConf appConf = this.dependencyManager.getWildFlySwarmApplicationConf(this.projectAsset);
        this.archive.add((Asset)new StringAsset(appConf.toString()), "META-INF/wildfly-swarm-application.conf");
    }

    private File createJar(String baseName, Path dir) throws IOException {
        File out = new File(dir.toFile(), baseName + "-swarm.jar");
        out.getParentFile().mkdirs();
        ZipExporter exporter = this.archive.as(ZipExporter.class);
        try (FileOutputStream fos = new FileOutputStream(out);){
            if (this.executable) {
                try (InputStream is = this.getLaunchScript();){
                    IOUtil.copy(is, fos);
                }
            }
            exporter.exportTo(fos);
        }
        if (this.executable) {
            out.setExecutable(true);
        }
        return out;
    }

    private InputStream getLaunchScript() throws IOException {
        return this.executableScript != null ? new FileInputStream(this.executableScript) : this.getClass().getResourceAsStream("launch.sh");
    }

    private void addAdditionalModules() throws IOException {
        for (String additionalModule : this.additionalModules) {
            File moduleDir = new File(additionalModule);
            this.archive.addAsResource(moduleDir, "modules");
            Files.find(moduleDir.toPath(), 20, (p, __) -> p.getFileName().toString().equals("module.xml"), new FileVisitOption[0]).forEach(p -> this.dependencyManager.addAdditionalModule((Path)p));
        }
    }

    private void populateUberJarMavenRepository() throws Exception {
        if (this.bundleDependencies) {
            this.dependencyManager.populateUberJarMavenRepository(this.archive);
        } else {
            this.dependencyManager.populateUserMavenRepository();
        }
    }

    public static interface SimpleLogger {
        public void info(String var1);

        public void error(String var1);

        public void error(String var1, Throwable var2);
    }

    public static enum FractionDetectionMode {
        when_missing,
        force,
        never;

    }
}

