/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;

public class ArtifactSpec
extends MavenArtifactDescriptor {
    public final String scope;
    public File file;
    public boolean shouldGather = true;

    public ArtifactSpec(String scope, String groupId, String artifactId, String version, String packaging, String classifier, File file) {
        super(groupId, artifactId, packaging, classifier, version);
        this.scope = scope;
        this.file = file;
    }

    public static ArtifactSpec fromMscGav(String gav) {
        String[] parts = gav.split(":");
        if (parts.length == 3) {
            return new ArtifactSpec("compile", parts[0], parts[1], parts[2], "jar", null, null);
        }
        if (parts.length == 4) {
            return new ArtifactSpec("compile", parts[0], parts[1], parts[2], "jar", parts[3], null);
        }
        throw new RuntimeException("Invalid gav: " + gav);
    }

    public String jarName() {
        String classifier = this.classifier();
        classifier = classifier != null && classifier.length() > 0 ? "-" + classifier : "";
        return String.format("%s-%s%s.%s", this.artifactId(), this.version(), classifier, this.type());
    }

    public String jarRepoPath() {
        return String.format("%s/%s/%s/%s", this.groupId().replace('.', '/'), this.artifactId(), this.version(), this.jarName());
    }

    public boolean isResolved() {
        return this.file != null;
    }

    @Override
    public String toString() {
        return this.mavenGav() + " [" + this.scope + "]";
    }
}

