/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.ClassAndPackageDetector;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.FractionList;

public class FractionUsageAnalyzer {
    private final List<File> sources = new ArrayList<File>();
    private final FractionList fractionList;
    private BuildTool.SimpleLogger log = BuildTool.NOP_LOGGER;

    public FractionUsageAnalyzer(FractionList fractionList) {
        this.fractionList = fractionList;
    }

    public FractionUsageAnalyzer source(Path source) {
        this.source(source.toFile());
        return this;
    }

    public FractionUsageAnalyzer source(File source) {
        this.sources.add(source);
        return this;
    }

    public FractionUsageAnalyzer logger(BuildTool.SimpleLogger log) {
        this.log = log;
        return this;
    }

    public Set<FractionDescriptor> detectNeededFractions() throws IOException {
        if (this.fractionList == null) {
            return Collections.emptySet();
        }
        HashSet<FractionDescriptor> specs = new HashSet<FractionDescriptor>();
        ClassAndPackageDetector detector = new ClassAndPackageDetector().logger(this.log).detect(this.sources);
        HashSet<String> detectables = new HashSet<String>(detector.packages());
        detectables.addAll(detector.classes().stream().map(FractionUsageAnalyzer::asClassNameMatch).collect(Collectors.toSet()));
        specs.addAll(this.findFractions(detectables));
        Iterator it = specs.iterator();
        while (it.hasNext()) {
            FractionDescriptor descriptor = (FractionDescriptor)it.next();
            if (!specs.stream().anyMatch(fd -> fd.getDependencies().contains(descriptor))) continue;
            it.remove();
        }
        if (specs.isEmpty()) {
            specs.add(this.fractionList.getFractionDescriptor("org.wildfly.swarm", "container"));
        }
        return specs;
    }

    private static String asClassNameMatch(String n) {
        int idx = n.lastIndexOf(46);
        if (idx < 0) {
            return n;
        }
        return n.substring(0, idx) + ":" + n.substring(idx + 1);
    }

    protected Set<FractionDescriptor> findFractions(Set<String> classesOrPackages) {
        List<StatefulMatcher> fractionPackages = this.fractionMatchers();
        return classesOrPackages.stream().flatMap(p -> fractionPackages.stream().map(m -> m.fraction((String)p))).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private List<StatefulMatcher> fractionMatchers() {
        ArrayList<StatefulMatcher> matchers = new ArrayList<StatefulMatcher>();
        this.fractionList.getPackageSpecs().forEach((spec, fd) -> Stream.of(spec.split(",")).forEach(s -> matchers.add(new StatefulMatcher((FractionDescriptor)fd, s.split("\\+")))));
        return matchers;
    }

    private static class StatefulMatcher {
        private final FractionDescriptor descriptor;
        private final Set<String> matchSpecs;
        private final Set<String> matches = new HashSet<String>();

        StatefulMatcher(FractionDescriptor desc, String ... matchSpecs) {
            this.descriptor = desc;
            this.matchSpecs = new HashSet<String>(Arrays.asList(matchSpecs));
        }

        public FractionDescriptor fraction(String name) {
            String match = this.matchingSpec(name);
            if (match != null) {
                this.matches.add(match);
            }
            return this.matches.equals(this.matchSpecs) ? this.descriptor : null;
        }

        private String matchingSpec(String name) {
            return this.matchSpecs.stream().filter(spec -> {
                if (spec.endsWith("*")) {
                    return name.startsWith(spec.substring(0, spec.length() - 1));
                }
                return name.equals(spec);
            }).findFirst().orElse(null);
        }
    }
}

