/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.wildfly.swarm.bootstrap.env.DependencyTree;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.bootstrap.env.ManifestComparator;
import org.wildfly.swarm.bootstrap.env.MavenDependencyResolution;
import org.wildfly.swarm.bootstrap.env.SystemDependencyResolution;
import org.wildfly.swarm.bootstrap.env.WildFlySwarmManifest;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.yaml.snakeyaml.Yaml;

public class ApplicationEnvironment {
    private Optional<DependencyTree<MavenArtifactDescriptor>> dependencyTree = Optional.empty();
    private Mode mode = Mode.CLASSPATH;
    private List<FractionManifest> manifests;
    private WildFlySwarmManifest applicationManifest;
    private List<String> bootstrapModules = new ArrayList<String>();
    private List<String> bootstrapArtifacts = new ArrayList<String>();
    private List<String> removeableDependencies = new ArrayList<String>();
    private static AtomicReference<ApplicationEnvironment> INSTANCE = new AtomicReference();
    public static final String DEFAULT_MAIN_CLASS_NAME = "org.wildfly.swarm.Swarm";

    public static ApplicationEnvironment get() {
        return INSTANCE.updateAndGet(env -> {
            if (env != null) {
                return env;
            }
            return new ApplicationEnvironment();
        });
    }

    private ApplicationEnvironment() {
        try {
            if (System.getProperty("swarm.isuberjar") != null) {
                this.mode = Mode.UBERJAR;
                if (!this.loadWildFlySwarmApplicationManifestFromClasspath()) {
                    this.loadWildFlySwarmApplicationManifestFromTCCL();
                }
            } else {
                this.mode = Mode.CLASSPATH;
                this.loadDependencyTree();
                this.loadFractionManifestsFromClasspath();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadDependencyTree() {
        String cpInfoProp = System.getProperty("swarm.cp.info");
        if (cpInfoProp != null) {
            try {
                DependencyTree<MavenArtifactDescriptor> dependencyTree = new DependencyTree<MavenArtifactDescriptor>();
                Yaml yaml = new Yaml();
                Map data = (Map)yaml.load(new FileInputStream(cpInfoProp));
                for (String directDep : data.keySet()) {
                    MavenArtifactDescriptor parent = MavenArtifactDescriptor.fromMavenGav(directDep);
                    Collection transientDeps = (Collection)data.get(directDep);
                    for (String transientDep : transientDeps) {
                        dependencyTree.add(parent, MavenArtifactDescriptor.fromMavenGav(transientDep));
                    }
                    if (!transientDeps.isEmpty()) continue;
                    dependencyTree.add(parent);
                }
                this.dependencyTree = Optional.of(dependencyTree);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load cp info", e);
            }
        }
    }

    public List<String> bootstrapModules() {
        return this.bootstrapModules;
    }

    public List<String> bootstrapArtifacts() {
        return this.bootstrapArtifacts;
    }

    public Mode getMode() {
        return this.mode;
    }

    private boolean loadWildFlySwarmApplicationManifestFromClasspath() throws IOException {
        return this.loadWildFlySwarmApplicationManifest(ClassLoader.getSystemClassLoader());
    }

    private boolean loadWildFlySwarmApplicationManifestFromTCCL() throws IOException {
        return this.loadWildFlySwarmApplicationManifest(Thread.currentThread().getContextClassLoader());
    }

    private boolean loadWildFlySwarmApplicationManifest(ClassLoader cl) throws IOException {
        URL url = cl.getResource("META-INF/wildfly-swarm-manifest.yaml");
        if (url == null) {
            return false;
        }
        this.applicationManifest = new WildFlySwarmManifest(url);
        this.bootstrapModules.addAll(this.applicationManifest.bootstrapModules());
        this.bootstrapArtifacts.addAll(this.applicationManifest.bootstrapArtifacts());
        return true;
    }

    private void loadFractionManifestsFromClasspath() throws IOException {
        this.loadFractionManifests(ClassLoader.getSystemClassLoader());
    }

    private void loadFractionManifestsFromUberjar() throws IOException, ModuleLoadException {
        if (this.manifests != null) {
            return;
        }
        this.manifests = new ArrayList<FractionManifest>();
        this.bootstrapModules.forEach(moduleName -> {
            try {
                Module module = Module.getBootModuleLoader().loadModule(ModuleIdentifier.create(moduleName));
                ModuleClassLoader cl = module.getClassLoader();
                Enumeration<URL> results = ((ClassLoader)cl).getResources("META-INF/fraction-manifest.yaml");
                while (results.hasMoreElements()) {
                    URL each = results.nextElement();
                    FractionManifest manifest = new FractionManifest(each);
                    this.manifests.add(manifest);
                }
            }
            catch (IOException | ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        });
        this.manifests.sort(new ManifestComparator());
    }

    private void loadFractionManifests(ClassLoader cl) throws IOException {
        if (this.manifests != null) {
            return;
        }
        this.manifests = new ArrayList<FractionManifest>();
        Enumeration<URL> results = cl.getResources("META-INF/fraction-manifest.yaml");
        while (results.hasMoreElements()) {
            URL each = results.nextElement();
            FractionManifest manifest = new FractionManifest(each);
            this.manifests.add(manifest);
            if (manifest.getModule() != null) {
                this.bootstrapModules.add(manifest.getModule());
            }
            if (this.mode != Mode.CLASSPATH) continue;
            HashSet<MavenArtifactDescriptor> applicationDependencies = new HashSet<MavenArtifactDescriptor>();
            if (this.dependencyTree.isPresent()) {
                HashSet<MavenArtifactDescriptor> topLevelFractions = new HashSet<MavenArtifactDescriptor>();
                MavenArtifactDescriptor source = new MavenArtifactDescriptor(manifest.getGroupId(), manifest.getArtifactId(), manifest.getVersion());
                for (MavenArtifactDescriptor target : this.dependencyTree.get().getDirectDeps()) {
                    if (!source.equals(target)) continue;
                    topLevelFractions.add(target);
                }
                HashSet<MavenArtifactDescriptor> keep = new HashSet<MavenArtifactDescriptor>(this.dependencyTree.get().getDirectDeps());
                keep.removeAll(topLevelFractions);
                for (MavenArtifactDescriptor dep : keep) {
                    applicationDependencies.add(dep);
                    applicationDependencies.addAll(this.dependencyTree.get().getTransientDeps(dep));
                }
            }
            this.removeableDependencies.addAll(manifest.getDependencies());
            this.removeableDependencies.removeAll(applicationDependencies);
        }
        HashSet<String> keep = new HashSet<String>();
        if (this.dependencyTree.isPresent()) {
            for (String toBeRemoved : this.removeableDependencies) {
                MavenArtifactDescriptor source = MavenArtifactDescriptor.fromMavenGav(toBeRemoved);
                for (MavenArtifactDescriptor target : this.dependencyTree.get().getDirectDeps()) {
                    if (!source.groupId().equals(target.groupId()) || !source.artifactId().equals(target.artifactId())) continue;
                    keep.add(toBeRemoved);
                }
            }
            this.removeableDependencies.removeAll(keep);
        }
        this.manifests.sort(new ManifestComparator());
    }

    public List<String> getDependencies() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.getDependencies();
        }
        return Collections.emptyList();
    }

    public List<String> getRemovableDependencies() {
        return this.removeableDependencies;
    }

    public Set<String> resolveDependencies(List<String> exclusions) throws IOException {
        if (this.mode == Mode.UBERJAR) {
            return new MavenDependencyResolution().resolve(exclusions);
        }
        return new SystemDependencyResolution().resolve(exclusions);
    }

    public String getAsset() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.getAsset();
        }
        return null;
    }

    public String getMainClassName() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.getMainClass();
        }
        return DEFAULT_MAIN_CLASS_NAME;
    }

    public boolean isHollow() {
        if (this.mode == Mode.UBERJAR) {
            return this.applicationManifest.isHollow();
        }
        return false;
    }

    private Path root() {
        URL location = ApplicationEnvironment.class.getProtectionDomain().getCodeSource().getLocation();
        if (location.getProtocol().equals("file")) {
            try {
                return Paths.get(location.toURI());
            }
            catch (URISyntaxException e) {
                return null;
            }
        }
        return null;
    }

    public ClassLoader getBootstrapClassLoader() throws ModuleLoadException {
        if (this.mode == Mode.UBERJAR) {
            try {
                return Module.getBootModuleLoader().loadModule(ModuleIdentifier.create("org.wildfly.swarm.bootstrap")).getClassLoader();
            }
            catch (ModuleLoadException moduleLoadException) {
                // empty catch block
            }
        }
        return ApplicationEnvironment.class.getClassLoader();
    }

    public List<FractionManifest> fractionManifests() {
        if (this.mode == Mode.UBERJAR && this.manifests == null) {
            try {
                this.loadFractionManifestsFromUberjar();
            }
            catch (IOException | ModuleLoadException e) {
                throw new RuntimeException(e);
            }
        }
        return this.manifests;
    }

    public static enum Mode {
        UBERJAR,
        CLASSPATH;

    }
}

