/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.swarmtool;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.wildfly.swarm.arquillian.resolver.ShrinkwrapArtifactResolvingHelper;
import org.wildfly.swarm.fractionlist.FractionList;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.BuildTool;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.wildfly.swarm.tools.FractionDescriptor;
import org.wildfly.swarm.tools.PropertiesUtil;

public class Main {
    private static final OptionParser OPT_PARSER = new OptionParser();
    private static final OptionSpec<Void> HOLLOW_OPT = OPT_PARSER.accepts("hollow", "creates a swarm jar containing only the fractions");
    private static final OptionSpec<Void> HELP_OPT = OPT_PARSER.acceptsAll(Arrays.asList("h", "help"), "print help and exit").forHelp();
    private static final OptionSpec<Void> VERSION_OPT = OPT_PARSER.acceptsAll(Arrays.asList("v", "version"), "print version and exit").forHelp();
    private static final OptionSpec<Void> DISABLE_AUTO_DETECT_OPT = OPT_PARSER.accepts("no-fraction-detect", "disable auto fraction detection");
    private static final OptionSpec<Void> DISABLE_BUNDLE_DEPS_OPT = OPT_PARSER.accepts("no-bundle-deps", "disable bundling of dependencies");
    private static final OptionSpec<Void> EXECUTABLE_OPT = OPT_PARSER.accepts("executable", "make the swarm jar executable");
    private static final OptionSpec<Void> DEBUG_LOGGING = OPT_PARSER.accepts("debug", "enable debug logging");
    private static final OptionSpec<String> FRACTIONS_OPT = OPT_PARSER.acceptsAll(Arrays.asList("f", "fractions"), "swarm fractions to include").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("undertow,jaxrs,...");
    private static final OptionSpec<String> REPOS_OPT = OPT_PARSER.accepts("repos", "additional maven repos to resolve against").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("url1,url2,...");
    private static final OptionSpec<String> OUTPUT_DIR_OPT = OPT_PARSER.acceptsAll(Arrays.asList("o", "output-dir"), "directory where the final jar will be written").withRequiredArg().ofType(String.class).defaultsTo(".", (String[])new String[0]).describedAs("path");
    private static final OptionSpec<String> MAIN_OPT = OPT_PARSER.accepts("main", "The name of the custom main class").withRequiredArg().ofType(String.class).describedAs("main-class");
    private static final OptionSpec<String> MODULES_OPT = OPT_PARSER.accepts("modules", "A list of JBoss Modules module dirs to include").withRequiredArg().ofType(String.class).withValuesSeparatedBy(',').describedAs("module-dir1,module-dir2,...");
    private static final OptionSpec<String> NAME_OPT = OPT_PARSER.acceptsAll(Arrays.asList("n", "name"), "The name of the final jar sans the -swarm.jar suffix (default: <source name>)").withRequiredArg().ofType(String.class).describedAs("jar-name");
    private static final OptionSpec<File> SOURCE_OPT = OPT_PARSER.nonOptions("The source artifact").ofType(File.class);
    private static final OptionSpec<String> SYSPROPS_OPT = OPT_PARSER.accepts("D", "system property (overrides entry in --property-file)").withRequiredArg().ofType(String.class).describedAs("key=value");
    private static final OptionSpec<File> SYSPROPS_FILE_OPT = OPT_PARSER.accepts("property-file", "system properties").withRequiredArg().ofType(File.class).describedAs("system properties file");
    protected static final String VERSION;

    public static void main(String[] args) throws Exception {
        try {
            Main.generateSwarmJar(args);
        }
        catch (ExitException e) {
            String msg = e.getMessage();
            if (msg != null) {
                System.err.println(msg);
            }
            if (e.printHelp) {
                if (msg != null) {
                    System.err.println();
                }
                System.err.println(String.format("Usage: %s <options> artifact-path\n", Main.executableName()));
                try {
                    OPT_PARSER.printHelpOn(System.err);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            System.exit(e.status);
        }
    }

    protected static String executableName() {
        String name = System.getenv("SWARMTOOL_NAME");
        if (name == null) {
            name = "java -jar swarmtool-standalone.jar";
        }
        return name;
    }

    protected static File generateSwarmJar(String[] args) throws Exception {
        File source;
        List<File> nonOptArgs;
        OptionSet foundOptions = null;
        try {
            foundOptions = OPT_PARSER.parse(args);
        }
        catch (OptionException e) {
            Main.exit(e.getMessage(), true);
        }
        if (foundOptions.has(HELP_OPT)) {
            Main.exit(null, 0, true);
        }
        if (foundOptions.has(VERSION_OPT)) {
            Main.exit("swarmtool v" + VERSION, 0);
        }
        if ((nonOptArgs = foundOptions.valuesOf(SOURCE_OPT)).isEmpty()) {
            Main.exit("No source artifact specified.", true);
        }
        if (nonOptArgs.size() > 1) {
            Main.exit("Too many source artifacts provided (" + nonOptArgs + ")", true);
        }
        if (!(source = nonOptArgs.get(0)).exists()) {
            Main.exit("File " + source.getAbsolutePath() + " does not exist.");
        }
        Properties properties = new Properties();
        if (foundOptions.has(SYSPROPS_FILE_OPT)) {
            try (FileInputStream in = new FileInputStream(foundOptions.valueOf(SYSPROPS_FILE_OPT));){
                properties.load(in);
            }
        }
        foundOptions.valuesOf(SYSPROPS_OPT).forEach(prop -> {
            String[] parts = prop.split("=");
            properties.put(parts[0], parts[1]);
        });
        String[] parts = source.getName().split("\\.(?=[^\\.]+$)");
        String baseName = parts[0];
        String type = parts[1] == null ? "jar" : parts[1];
        String jarName = foundOptions.has(NAME_OPT) ? foundOptions.valueOf(NAME_OPT) : baseName;
        String outDir = new File(foundOptions.valueOf(OUTPUT_DIR_OPT)).getCanonicalPath();
        String suffix = foundOptions.has(HOLLOW_OPT) ? "-hollow-swarm" : "-swarm";
        BuildTool tool = new BuildTool(Main.getResolvingHelper(foundOptions.valuesOf(REPOS_OPT))).projectArtifact("", baseName, "", type, source).declaredDependencies(new DeclaredDependencies()).fractionList(FractionList.get()).fractionDetectionMode(foundOptions.has(DISABLE_AUTO_DETECT_OPT) ? BuildTool.FractionDetectionMode.never : BuildTool.FractionDetectionMode.force).bundleDependencies(!foundOptions.has(DISABLE_BUNDLE_DEPS_OPT)).executable(foundOptions.has(EXECUTABLE_OPT)).properties(properties).hollow(foundOptions.has(HOLLOW_OPT));
        if (foundOptions.has(MAIN_OPT)) {
            tool.mainClass(foundOptions.valueOf(MAIN_OPT));
        }
        if (foundOptions.has(MODULES_OPT)) {
            tool.additionalModules(foundOptions.valuesOf(MODULES_OPT));
        }
        if (foundOptions.has(DEBUG_LOGGING)) {
            tool.logger(BuildTool.STD_LOGGER_WITH_DEBUG);
        }
        Main.addSwarmFractions(tool, foundOptions.valuesOf(FRACTIONS_OPT));
        System.err.println(String.format("Building %s/%s-%s.jar", outDir, jarName, suffix));
        return tool.build(jarName, Paths.get(outDir, new String[0]));
    }

    private static void exit(String message) {
        Main.exit(message, 1);
    }

    private static void exit(String message, boolean printHelp) {
        Main.exit(message, 1, printHelp);
    }

    private static void exit(String message, int code) {
        Main.exit(message, code, false);
    }

    private static void exit(String message, int code, boolean printHelp) {
        throw new ExitException(code, printHelp, message);
    }

    private static ArtifactResolvingHelper getResolvingHelper(List<String> repos) {
        ConfigurableMavenResolverSystem resolver = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(MavenRemoteRepositories.createRemoteRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", "default").setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE).setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER));
        repos.forEach(r -> {
            ConfigurableMavenResolverSystem cfr_ignored_0 = (ConfigurableMavenResolverSystem)resolver.withRemoteRepo(MavenRemoteRepositories.createRemoteRepository(r, r, "default").setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE).setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER));
        });
        return new ShrinkwrapArtifactResolvingHelper(resolver);
    }

    private static void addSwarmFractions(BuildTool tool, List<String> deps) {
        deps.stream().map(f -> f.split(":")).map(parts -> {
            switch (((String[])parts).length) {
                case 1: {
                    FractionDescriptor desc = FractionList.get().getFractionDescriptor("org.wildfly.swarm", parts[0]);
                    if (desc != null) {
                        return desc;
                    }
                    System.err.println("Warning: Unknown fraction: " + parts[0]);
                    return null;
                }
                case 2: {
                    return new FractionDescriptor("org.wildfly.swarm", parts[0], parts[1]);
                }
                case 3: {
                    return new FractionDescriptor(parts[0], parts[1], parts[2]);
                }
            }
            System.err.println("Warning: Invalid fraction specifier: " + String.join((CharSequence)":", parts));
            return null;
        }).filter(f -> f != null).forEach(f -> tool.fraction(f.toArtifactSpec()));
    }

    static {
        try {
            VERSION = PropertiesUtil.loadProperties(Main.class.getClassLoader().getResourceAsStream("org/wildfly/swarm/swarmtool/version.properties")).getProperty("version");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load version.properties", e);
        }
    }

    static class ExitException
    extends RuntimeException {
        public int status;
        public boolean printHelp;

        ExitException(int status, boolean printHelp, String message) {
            super(message);
            this.printHelp = printHelp;
            this.status = status;
        }
    }
}

