/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.bootstrap.env.WildFlySwarmManifest;
import org.wildfly.swarm.tools.ArtifactResolver;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.DeclaredDependencies;
import org.wildfly.swarm.tools.ModuleAnalyzer;
import org.wildfly.swarm.tools.ProjectAsset;
import org.wildfly.swarm.tools.ResolvedDependencies;

public class DependencyManager
implements ResolvedDependencies {
    private static final String JAR = "jar";
    private final WildFlySwarmManifest applicationManifest = new WildFlySwarmManifest();
    private final Set<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> removableDependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> moduleDependencies = new HashSet<ArtifactSpec>();
    private ProjectAsset projectAsset;
    private ArtifactResolver resolver;

    public DependencyManager(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public void addAdditionalModule(Path module) {
        try {
            this.analyzeModuleDependencies(new ModuleAnalyzer(module));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<ArtifactSpec> getDependencies() {
        return this.dependencies;
    }

    @Override
    public ArtifactSpec findWildFlySwarmBootstrapJar() {
        return this.findArtifact("org.wildfly.swarm", "bootstrap", null, JAR, null);
    }

    @Override
    public ArtifactSpec findJBossModulesJar() {
        return this.findArtifact("org.jboss.modules", "jboss-modules", null, JAR, null);
    }

    @Override
    public ArtifactSpec findArtifact(String groupId, String artifactId, String version, String packaging, String classifier) {
        for (ArtifactSpec each : this.dependencies) {
            if (groupId != null && !groupId.equals(each.groupId()) || artifactId != null && !artifactId.equals(each.artifactId()) || version != null && !version.equals(each.version()) || packaging != null && !packaging.equals(each.type()) || classifier != null && !classifier.equals(each.classifier())) continue;
            return each;
        }
        return null;
    }

    public ResolvedDependencies analyzeDependencies(boolean autodetect, DeclaredDependencies declaredDependencies) throws Exception {
        this.resolveDependencies(declaredDependencies, autodetect);
        this.analyzeRemovableDependencies(declaredDependencies);
        this.analyzeFractionManifests(declaredDependencies);
        this.dependencies.stream().filter(e -> !this.removableDependencies.contains(e)).forEach(e -> this.applicationManifest.addDependency(e.mavenGav()));
        this.analyzeModuleDependencies(declaredDependencies);
        return this;
    }

    private void resolveDependencies(DeclaredDependencies declaredDependencies, boolean autodetect) throws Exception {
        this.dependencies.clear();
        boolean resolveExplicitsTransitively = !declaredDependencies.isPresolved() || autodetect;
        Set<ArtifactSpec> resolvedExplicitDependencies = resolveExplicitsTransitively ? this.resolver.resolveAllArtifactsTransitively(declaredDependencies.getExplicitDependencies(), false) : this.resolver.resolveAllArtifactsNonTransitively(declaredDependencies.getExplicitDependencies());
        this.dependencies.addAll(resolvedExplicitDependencies);
        if (declaredDependencies.getTransientDependencies().isEmpty()) {
            Set<ArtifactSpec> inputSet = declaredDependencies.getExplicitDependencies();
            Set<ArtifactSpec> filtered = inputSet.stream().filter(dep -> dep.type().equals(JAR)).collect(Collectors.toSet());
            Set<ArtifactSpec> resolvedTransientDependencies = this.resolver.resolveAllArtifactsTransitively(filtered, false);
            this.dependencies.addAll(resolvedTransientDependencies);
            HashSet<ArtifactSpec> remainder = new HashSet<ArtifactSpec>();
            inputSet.stream().forEach(remainder::add);
            remainder.removeAll(resolvedTransientDependencies);
            this.dependencies.addAll(this.resolver.resolveAllArtifactsNonTransitively(remainder));
        } else {
            Set<ArtifactSpec> inputSet = declaredDependencies.getTransientDependencies();
            Set<ArtifactSpec> filtered = inputSet.stream().filter(dep -> dep.type().equals(JAR)).collect(Collectors.toSet());
            Set<ArtifactSpec> resolvedTransientDependencies = Collections.EMPTY_SET;
            if (filtered.size() > 0) {
                resolvedTransientDependencies = this.resolver.resolveAllArtifactsNonTransitively(filtered);
                this.dependencies.addAll(resolvedTransientDependencies);
            }
            HashSet<ArtifactSpec> remainder = new HashSet<ArtifactSpec>();
            inputSet.stream().forEach(remainder::add);
            remainder.removeAll(resolvedTransientDependencies);
            this.dependencies.addAll(this.resolver.resolveAllArtifactsNonTransitively(remainder));
        }
    }

    private void analyzeModuleDependencies(DeclaredDependencies declaredDependencies) {
        this.dependencies.stream().filter(e -> e.type().equals(JAR)).map(e -> e.file).flatMap(ResolvedDependencies::findModuleXmls).forEach(this::analyzeModuleDependencies);
    }

    private void analyzeModuleDependencies(ModuleAnalyzer analyzer) {
        this.moduleDependencies.addAll(analyzer.getDependencies());
    }

    private void analyzeRemovableDependencies(DeclaredDependencies declaredDependencies) throws Exception {
        Set bootstrapDeps = this.dependencies.stream().filter(e -> DependencyManager.isFractionJar(e.file)).collect(Collectors.toSet());
        HashSet<ArtifactSpec> nonBootstrapDeps = new HashSet<ArtifactSpec>();
        nonBootstrapDeps.addAll(declaredDependencies.getExplicitDependencies());
        nonBootstrapDeps.removeAll(bootstrapDeps);
        Set<ArtifactSpec> nonBootstrapTransitive = this.resolver.resolveAllArtifactsTransitively(nonBootstrapDeps, true);
        Set justJars = this.dependencies.stream().filter(e -> e.type().equals(JAR)).collect(Collectors.toSet());
        this.removableDependencies.addAll(justJars);
        this.removableDependencies.removeAll(nonBootstrapTransitive);
    }

    private void analyzeFractionManifests(DeclaredDependencies declaredDependencies) {
        this.dependencies.stream().map(e -> this.fractionManifest(e.file)).filter(e -> e != null).forEach(manifest -> {
            String module = manifest.getModule();
            if (module != null) {
                this.applicationManifest.addBootstrapModule(module);
            }
        });
        this.dependencies.stream().filter(e -> DependencyManager.isFractionJar(e.file) || this.isConfigApiModulesJar(e.file)).forEach(artifact -> this.applicationManifest.addBootstrapArtifact(artifact.mavenGav()));
    }

    Set<ArtifactSpec> getRemovableDependencies() {
        return this.removableDependencies;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRemovable(Node node) {
        Asset asset = node.getAsset();
        if (asset == null) {
            return false;
        }
        String path = node.getPath().get();
        try (InputStream inputStream = asset.openStream();){
            byte[] checksum = this.checksum(inputStream);
            boolean bl = this.removableDependencies.stream().filter(e -> path.endsWith(e.artifactId() + "-" + e.version() + ".jar")).map(e -> {
                try (FileInputStream in = new FileInputStream(e.file);){
                    byte[] byArray = this.checksum(in);
                    return byArray;
                }
                catch (IOException | DigestException | NoSuchAlgorithmException e1) {
                    return null;
                }
            }).filter(e -> e != null).anyMatch(e -> Arrays.equals(e, checksum));
            return bl;
        }
        catch (IOException | DigestException | NoSuchAlgorithmException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    protected byte[] checksum(InputStream in) throws IOException, NoSuchAlgorithmException, DigestException {
        byte[] buf = new byte[1024];
        int len = 0;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        while ((len = in.read(buf)) >= 0) {
            md.update(buf, 0, len);
        }
        return md.digest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isConfigApiModulesJar(File file) {
        if (file == null) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            boolean bl = jar.getEntry("wildfly-swarm-modules.conf") != null;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isFractionJar(File file) {
        if (file == null) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            boolean bl = jar.getEntry("META-INF/fraction-manifest.yaml") != null;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected FractionManifest fractionManifest(File file) {
        block30: {
            try {
                Throwable throwable = null;
                try (JarFile jar = new JarFile(file);){
                    ZipEntry entry = jar.getEntry("META-INF/fraction-manifest.yaml");
                    if (entry != null) {
                        try (InputStream in = jar.getInputStream(entry);){
                            FractionManifest fractionManifest = new FractionManifest(in);
                            return fractionManifest;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    void setProjectAsset(ProjectAsset projectAsset) {
        if (!this.applicationManifest.isHollow()) {
            this.projectAsset = projectAsset;
            this.applicationManifest.setAsset(this.projectAsset.getName());
        }
    }

    protected WildFlySwarmManifest getWildFlySwarmManifest() {
        return this.applicationManifest;
    }

    @Override
    public Set<ArtifactSpec> getModuleDependencies() {
        return this.moduleDependencies;
    }
}

