/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.jboss.shrinkwrap.api.Node;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.ModuleAnalyzer;

public interface ResolvedDependencies {
    public static final String WILDFLY_SWARM_GROUP_ID = "org.wildfly.swarm";
    public static final String WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID = "bootstrap";
    public static final String JBOSS_MODULES_GROUP_ID = "org.jboss.modules";
    public static final String JBOSS_MODULES_ARTIFACT_ID = "jboss-modules";

    public Set<ArtifactSpec> getDependencies();

    public ArtifactSpec findWildFlySwarmBootstrapJar();

    public ArtifactSpec findJBossModulesJar();

    public ArtifactSpec findArtifact(String var1, String var2, String var3, String var4, String var5);

    public static boolean isExplodedBootstrap(ArtifactSpec dependency) {
        if (dependency.groupId().equals(JBOSS_MODULES_GROUP_ID) && dependency.artifactId().equals(JBOSS_MODULES_ARTIFACT_ID)) {
            return true;
        }
        return dependency.groupId().equals(WILDFLY_SWARM_GROUP_ID) && dependency.artifactId().equals(WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID);
    }

    public static Stream<ModuleAnalyzer> findModuleXmls(File file) {
        ArrayList<ModuleAnalyzer> analyzers = new ArrayList<ModuleAnalyzer>();
        try (JarFile jar = new JarFile(file);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry each = entries.nextElement();
                String name = each.getName();
                if (!name.startsWith("modules/") || !name.endsWith("module.xml")) continue;
                try {
                    InputStream in = jar.getInputStream(each);
                    Throwable throwable = null;
                    try {
                        analyzers.add(new ModuleAnalyzer(in));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return analyzers.stream();
    }

    public boolean isRemovable(Node var1);

    public Set<ArtifactSpec> getModuleDependencies();
}

