/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.FractionList;
import org.wildfly.swarm.tools.FractionStability;

public class FractionDescriptor {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String name;
    private final String description;
    private final String tags;
    private final boolean internal;
    private final Set<FractionDescriptor> dependencies = new HashSet<FractionDescriptor>();
    private final FractionStability stability;

    public FractionDescriptor(String groupId, String artifactId, String version, String name, String description, String tags, boolean internal, FractionStability stability) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.name = name;
        this.description = description;
        this.tags = tags;
        this.internal = internal;
        this.stability = stability;
    }

    public FractionDescriptor(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null, null, false, FractionStability.UNSTABLE);
    }

    public static FractionDescriptor fromGav(FractionList fractionList, String gav) {
        String[] parts = gav.split(":");
        FractionDescriptor desc = null;
        switch (parts.length) {
            case 1: {
                desc = fractionList.getFractionDescriptor("org.wildfly.swarm", parts[0]);
                break;
            }
            case 2: {
                desc = new FractionDescriptor("org.wildfly.swarm", parts[0], parts[1]);
                break;
            }
            case 3: {
                desc = new FractionDescriptor(parts[0], parts[1], parts[2]);
            }
        }
        if (desc == null) {
            throw new RuntimeException("Invalid fraction spec: " + gav);
        }
        return desc;
    }

    public static FractionDescriptor fromArtifactSpec(ArtifactSpec spec) {
        return new FractionDescriptor(spec.groupId(), spec.artifactId(), spec.version());
    }

    public void addDependency(FractionDescriptor dep) {
        this.dependencies.add(dep);
    }

    @Deprecated
    public String groupId() {
        return this.groupId;
    }

    @Deprecated
    public String artifactId() {
        return this.artifactId;
    }

    @Deprecated
    public String version() {
        return this.version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public FractionStability getStability() {
        return this.stability;
    }

    public Set<FractionDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public ArtifactSpec toArtifactSpec() {
        return ArtifactSpec.fromMscGav(this.toString());
    }

    public String av() {
        return this.artifactId + ":" + this.version;
    }

    public String gav() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public String gavOrAv() {
        if ("org.wildfly.swarm".equals(this.groupId)) {
            return this.av();
        }
        return this.gav();
    }

    public String toString() {
        return this.gav();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FractionDescriptor other = (FractionDescriptor)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        return !(this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId));
    }
}

