/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.IterableResourceLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.ClassFilters;
import org.jboss.modules.filter.PathFilters;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.bootstrap.util.TempFileManager;

public class WildFlySwarmApplicationConf {
    public static final String CLASSPATH_LOCATION = "META-INF/wildfly-swarm-application.conf";
    private List<Entry> entries = new ArrayList<Entry>();

    public WildFlySwarmApplicationConf() {
    }

    public WildFlySwarmApplicationConf(InputStream in) throws IOException {
        this.read(in);
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void apply(ModuleSpec.Builder builder) throws Exception {
        for (Entry entry : this.entries) {
            entry.apply(builder);
        }
    }

    public void write(OutputStream out) {
        PrintWriter writer = new PrintWriter(out);
        this.entries.stream().sorted().distinct().forEach(e -> e.write(writer));
        writer.flush();
    }

    public String toString() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.write(out);
            out.close();
            return new String(out.toByteArray());
        }
        catch (IOException e) {
            return "";
        }
    }

    protected void read(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                Entry entry = null;
                if (line.startsWith("fraction-module:")) {
                    line = line.substring(16).trim();
                    entry = new FractionModuleEntry(line);
                } else if (line.startsWith("module:")) {
                    line = line.substring(7).trim();
                    entry = new ModuleEntry(line);
                } else if (line.startsWith("gav:")) {
                    line = line.substring(4).trim();
                    entry = new GAVEntry(MavenArtifactDescriptor.fromMscGav(line));
                } else if (line.startsWith("path:")) {
                    line = line.substring(5).trim();
                    entry = new PathEntry(line);
                }
                if (entry == null) continue;
                this.entries.add(entry);
            }
        }
    }

    public static class PathEntry
    extends Entry {
        private final String path;

        public PathEntry(String path) {
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        @Override
        void apply(ModuleSpec.Builder builder) throws IOException {
            int slashLoc = this.path.lastIndexOf(47);
            String name = this.path;
            if (slashLoc > 0) {
                name = this.path.substring(slashLoc + 1);
            }
            String ext = ".jar";
            int dotLoc = name.lastIndexOf(46);
            if (dotLoc > 0) {
                ext = name.substring(dotLoc);
                name = name.substring(0, dotLoc);
            }
            File tmp = TempFileManager.INSTANCE.newTempFile(name, ext);
            try (InputStream artifactIn = this.getClass().getClassLoader().getResourceAsStream(this.path);){
                Files.copy(artifactIn, tmp.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            String jarName = tmp.getName().toString();
            JarFile jarFile = new JarFile(tmp);
            ResourceLoader jarLoader = ResourceLoaders.createJarResourceLoader(jarName, jarFile);
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(jarLoader));
            if (".war".equalsIgnoreCase(ext)) {
                IterableResourceLoader warLoader = ResourceLoaders.createJarResourceLoader(jarName, jarFile, "WEB-INF/classes");
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(warLoader));
            }
        }

        @Override
        void write(PrintWriter writer) {
            writer.println("path:" + this.path);
        }

        public int compareTo(Object that) {
            if (that instanceof PathEntry) {
                return this.path.compareTo(((PathEntry)that).path);
            }
            return this.getClass().getName().compareTo(that.getClass().getName());
        }

        public boolean equals(Object that) {
            if (that instanceof PathEntry) {
                return this.path.equals(((PathEntry)that).path);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    public static class GAVEntry
    extends Entry {
        private final MavenArtifactDescriptor descriptor;

        public GAVEntry(MavenArtifactDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public MavenArtifactDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        void apply(ModuleSpec.Builder builder) throws IOException {
            File artifact = MavenResolvers.get().resolveJarArtifact(this.descriptor.mscCoordinates());
            if (artifact == null) {
                throw new IOException("Unable to locate artifact: " + this.descriptor.mscGav());
            }
            builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(ResourceLoaders.createJarResourceLoader(artifact.getName(), new JarFile(artifact))));
        }

        @Override
        void write(PrintWriter writer) {
            writer.println("gav:" + this.descriptor.mscGav());
        }

        public int compareTo(Object that) {
            if (that instanceof GAVEntry) {
                this.descriptor.compareTo(((GAVEntry)that).descriptor);
            }
            return this.getClass().getName().compareTo(that.getClass().getName());
        }

        public boolean equals(Object that) {
            if (that instanceof GAVEntry) {
                return this.descriptor.equals(((GAVEntry)that).descriptor);
            }
            return false;
        }

        public int hashCode() {
            return this.descriptor.hashCode();
        }

        public String toString() {
            return "gav: " + this.descriptor;
        }
    }

    public static class FractionModuleEntry
    extends Entry {
        private final String name;
        private final String slot;

        public FractionModuleEntry(String name) {
            String[] parts = name.split(":");
            this.name = parts[0];
            this.slot = parts.length == 2 ? parts[1] : "main";
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void apply(ModuleSpec.Builder builder) {
            builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, ModuleIdentifier.create(this.name, this.slot), false));
        }

        @Override
        void write(PrintWriter writer) {
            writer.println("fraction-module:" + this.name + ":" + this.slot);
        }

        public int compareTo(Object that) {
            if (that instanceof FractionModuleEntry) {
                int result = this.name.compareTo(((FractionModuleEntry)that).name);
                if (result != 0) {
                    return result;
                }
                return this.slot.compareTo(((FractionModuleEntry)that).slot);
            }
            return this.getClass().getName().compareTo(that.getClass().getName());
        }

        public boolean equals(Object that) {
            if (that instanceof FractionModuleEntry) {
                return this.name.equals(((FractionModuleEntry)that).name) && this.slot.equals(((FractionModuleEntry)that).slot);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.slot.hashCode();
        }

        public String toString() {
            return "module: " + this.name + ":" + this.slot;
        }
    }

    public static class ModuleEntry
    extends Entry {
        private final String name;
        private final String slot;

        public ModuleEntry(String name) {
            String[] parts = name.split(":");
            this.name = parts[0];
            this.slot = parts.length == 2 ? parts[1] : "main";
        }

        public String getName() {
            return this.name;
        }

        @Override
        void apply(ModuleSpec.Builder builder) {
            builder.addDependency(DependencySpec.createModuleDependencySpec(PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), PathFilters.acceptAll(), ClassFilters.acceptAll(), ClassFilters.acceptAll(), null, ModuleIdentifier.create(this.name, this.slot), false));
        }

        @Override
        void write(PrintWriter writer) {
            writer.println("module:" + this.name + ":" + this.slot);
        }

        public int compareTo(Object that) {
            if (that instanceof ModuleEntry) {
                int result = this.name.compareTo(((ModuleEntry)that).name);
                if (result != 0) {
                    return result;
                }
                return this.slot.compareTo(((ModuleEntry)that).slot);
            }
            return this.getClass().getName().compareTo(that.getClass().getName());
        }

        public boolean equals(Object that) {
            if (that instanceof ModuleEntry) {
                return this.name.equals(((ModuleEntry)that).name) && this.slot.equals(((ModuleEntry)that).slot);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() + this.slot.hashCode();
        }

        public String toString() {
            return "module: " + this.name + ":" + this.slot;
        }
    }

    public static abstract class Entry
    implements Comparable {
        abstract void apply(ModuleSpec.Builder var1) throws Exception;

        abstract void write(PrintWriter var1);
    }
}

