/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.FileAsset;
import org.wildfly.swarm.bootstrap.env.FractionManifest;
import org.wildfly.swarm.bootstrap.env.WildFlySwarmManifest;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;
import org.wildfly.swarm.tools.BuildException;
import org.wildfly.swarm.tools.ModuleAnalyzer;
import org.wildfly.swarm.tools.ProjectAsset;

public class DependencyManager {
    public static final String WILDFLY_SWARM_GROUP_ID = "org.wildfly.swarm";
    public static final String WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID = "bootstrap";
    public static final String JBOSS_MODULES_GROUP_ID = "org.jboss.modules";
    public static final String JBOSS_MODULES_ARTIFACT_ID = "jboss-modules";
    private final WildFlySwarmManifest applicationManifest = new WildFlySwarmManifest();
    private final Set<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> removableDependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> moduleDependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> explicitDependencies = new HashSet<ArtifactSpec>();
    private final Set<ArtifactSpec> presolvedDependencies = new HashSet<ArtifactSpec>();
    private ProjectAsset projectAsset;
    private ArtifactResolvingHelper resolver;

    public void setArtifactResolvingHelper(ArtifactResolvingHelper resolver) {
        this.resolver = resolver;
    }

    public void addExplicitDependency(ArtifactSpec dep) {
        this.explicitDependencies.add(dep);
    }

    public void addPresolvedDependency(ArtifactSpec dep) {
        this.presolvedDependencies.add(dep);
    }

    public void addAdditionalModule(Path module) {
        try {
            this.analyzeModuleDependencies(new ModuleAnalyzer(module));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<ArtifactSpec> getDependencies() {
        return this.dependencies;
    }

    public boolean isExplodedBootstrap(ArtifactSpec dependency) {
        if (dependency.groupId().equals(JBOSS_MODULES_GROUP_ID) && dependency.artifactId().equals(JBOSS_MODULES_ARTIFACT_ID)) {
            return true;
        }
        return dependency.groupId().equals(WILDFLY_SWARM_GROUP_ID) && dependency.artifactId().equals(WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID);
    }

    public ArtifactSpec findWildFlySwarmBootstrapJar() {
        return this.findArtifact(WILDFLY_SWARM_GROUP_ID, WILDFLY_SWARM_BOOTSTRAP_ARTIFACT_ID, null, "jar", null);
    }

    public ArtifactSpec findJBossModulesJar() {
        return this.findArtifact(JBOSS_MODULES_GROUP_ID, JBOSS_MODULES_ARTIFACT_ID, null, "jar", null);
    }

    public ArtifactSpec findArtifact(String groupId, String artifactId, String version, String packaging, String classifier) {
        for (ArtifactSpec each : this.dependencies) {
            if (groupId != null && !groupId.equals(each.groupId()) || artifactId != null && !artifactId.equals(each.artifactId()) || version != null && !version.equals(each.version()) || packaging != null && !packaging.equals(each.type()) || classifier != null && !classifier.equals(each.classifier())) continue;
            return each;
        }
        return null;
    }

    public void populateUberJarMavenRepository(Archive archive) throws Exception {
        HashSet<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
        for (ArtifactSpec dependency : this.dependencies) {
            if (!this.isExplodedBootstrap(dependency)) {
                dependency.shouldGather = true;
            }
            if (this.isExplodedBootstrap(dependency)) {
                dependency.shouldGather = false;
            }
            if (!dependency.shouldGather) continue;
            dependencies.add(dependency);
        }
        for (ArtifactSpec dependency : this.moduleDependencies) {
            dependencies.add(dependency);
        }
        this.resolveAllArtifactsNonTransitively(dependencies);
        for (ArtifactSpec dependency : dependencies) {
            this.addArtifactToArchiveMavenRepository(archive, dependency);
        }
    }

    public void populateUserMavenRepository() throws Exception {
        HashSet<ArtifactSpec> dependencies = new HashSet<ArtifactSpec>();
        dependencies.addAll(this.dependencies);
        dependencies.addAll(this.moduleDependencies);
        this.resolveAllArtifactsNonTransitively(dependencies);
    }

    public void addArtifactToArchiveMavenRepository(Archive archive, ArtifactSpec artifact) throws Exception {
        if (artifact.gathered) {
            return;
        }
        artifact = this.resolveArtifact(artifact);
        StringBuilder artifactPath = new StringBuilder("m2repo/");
        artifactPath.append(artifact.repoPath(true));
        archive.add((Asset)new FileAsset(artifact.file), artifactPath.toString());
        artifact.gathered = true;
    }

    protected static Stream<ModuleAnalyzer> findModuleXmls(File file) {
        ArrayList<ModuleAnalyzer> analyzers = new ArrayList<ModuleAnalyzer>();
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry each = entries.nextElement();
                String name = each.getName();
                if (!name.startsWith("modules/") || !name.endsWith("module.xml")) continue;
                InputStream in = jar.getInputStream(each);
                analyzers.add(new ModuleAnalyzer(in));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return analyzers.stream();
    }

    protected void analyzeDependencies(boolean autodetect) throws Exception {
        Set<ArtifactSpec> allResolvedDependencies = this.resolveAllArtifactsTransitively(this.explicitDependencies);
        this.dependencies.clear();
        if (this.presolvedDependencies.isEmpty()) {
            this.dependencies.addAll(allResolvedDependencies);
        } else {
            allResolvedDependencies.stream().filter(dep -> autodetect || this.presolvedDependencies.contains(dep)).forEach(dep -> this.dependencies.add((ArtifactSpec)dep));
        }
        this.analyzeRemovableDependencies();
        this.analyzeFractionManifests();
        this.dependencies.stream().filter(e -> !this.removableDependencies.contains(e)).forEach(e -> this.applicationManifest.addDependency(e.mavenGav()));
        this.analyzeModuleDependencies();
    }

    protected void analyzeModuleDependencies() {
        this.dependencies.stream().filter(e -> e.type().equals("jar")).map(e -> e.file).flatMap(DependencyManager::findModuleXmls).forEach(this::analyzeModuleDependencies);
    }

    protected void analyzeModuleDependencies(ModuleAnalyzer analyzer) {
        this.moduleDependencies.addAll(analyzer.getDependencies());
    }

    protected void analyzeRemovableDependencies() throws Exception {
        Set bootstrapDeps = this.dependencies.stream().filter(e -> this.isFractionJar(e.file)).collect(Collectors.toSet());
        HashSet<ArtifactSpec> nonBootstrapDeps = new HashSet<ArtifactSpec>();
        nonBootstrapDeps.addAll(this.explicitDependencies);
        nonBootstrapDeps.removeAll(bootstrapDeps);
        Set<ArtifactSpec> simplifiedDeps = this.resolveAllArtifactsTransitively(nonBootstrapDeps);
        Set justJars = this.dependencies.stream().filter(e -> e.type().equals("jar")).collect(Collectors.toSet());
        this.removableDependencies.addAll(justJars);
        this.removableDependencies.removeAll(simplifiedDeps);
    }

    protected void analyzeFractionManifests() {
        this.dependencies.stream().map(e -> this.fractionManifest(e.file)).filter(e -> e != null).forEach(manifest -> {
            String module = manifest.getModule();
            if (module != null) {
                this.applicationManifest.addBootstrapModule(module);
            }
        });
        this.dependencies.stream().filter(e -> this.isFractionJar(e.file) || this.isConfigApiModulesJar(e.file)).forEach(artifact -> this.applicationManifest.addBootstrapArtifact(artifact.mavenGav()));
    }

    public Set<ArtifactSpec> getRemovableDependencies() {
        return this.removableDependencies;
    }

    public boolean isRemovable(Node node) {
        Asset asset = node.getAsset();
        if (asset == null) {
            return false;
        }
        String path = node.getPath().get();
        try {
            byte[] checksum = this.checksum(asset.openStream());
            return this.removableDependencies.stream().filter(e -> path.endsWith(e.artifactId() + "-" + e.version() + ".jar")).map(e -> {
                try {
                    return this.checksum(new FileInputStream(e.file));
                }
                catch (IOException | DigestException | NoSuchAlgorithmException e1) {
                    return null;
                }
            }).filter(e -> e != null).anyMatch(e -> Arrays.equals(e, checksum));
        }
        catch (IOException | DigestException | NoSuchAlgorithmException e2) {
            e2.printStackTrace();
            return false;
        }
    }

    protected byte[] checksum(InputStream in) throws IOException, NoSuchAlgorithmException, DigestException {
        byte[] buf = new byte[1024];
        int len = 0;
        MessageDigest md = MessageDigest.getInstance("SHA1");
        while ((len = in.read(buf)) >= 0) {
            md.update(buf, 0, len);
        }
        return md.digest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isConfigApiModulesJar(File file) {
        if (file == null) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            boolean bl = jar.getEntry("wildfly-swarm-modules.conf") != null;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isFractionJar(File file) {
        if (file == null) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            boolean bl = jar.getEntry("META-INF/fraction-manifest.yaml") != null;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    protected FractionManifest fractionManifest(File file) {
        block30: {
            try {
                Throwable throwable = null;
                try (JarFile jar = new JarFile(file);){
                    ZipEntry entry = jar.getEntry("META-INF/fraction-manifest.yaml");
                    if (entry != null) {
                        try (InputStream in = jar.getInputStream(entry);){
                            FractionManifest fractionManifest = new FractionManifest(in);
                            return fractionManifest;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    void setProjectAsset(ProjectAsset projectAsset) {
        if (!this.applicationManifest.isHollow()) {
            this.projectAsset = projectAsset;
            this.applicationManifest.setAsset(this.projectAsset.getName());
        }
    }

    protected WildFlySwarmManifest getWildFlySwarmManifest() {
        return this.applicationManifest;
    }

    protected ArtifactSpec resolveArtifact(ArtifactSpec spec) throws Exception {
        if (spec.file == null) {
            ArtifactSpec newArtifact = this.resolver.resolve(spec);
            if (newArtifact == null) {
                throw new BuildException("Unable to resolve artifact: " + spec);
            }
            spec.file = newArtifact.file;
        }
        return spec;
    }

    protected Set<ArtifactSpec> resolveAllArtifactsTransitively(Set<ArtifactSpec> specs) throws Exception {
        return this.resolver.resolveAll(specs);
    }

    protected Set<ArtifactSpec> resolveAllArtifactsNonTransitively(Set<ArtifactSpec> specs) throws Exception {
        return this.resolver.resolveAll(specs, false);
    }
}

