/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.impl.base.GenericArchiveImpl;
import org.wildfly.swarm.tools.DependencyManager;

public class WebInfLibFilteringArchive
extends GenericArchiveImpl {
    public WebInfLibFilteringArchive(Archive<?> archive, DependencyManager dependencyManager) {
        super(archive);
        this.filter(dependencyManager);
    }

    protected void filter(DependencyManager dependencyManager) {
        HashSet<ArchivePath> remove = new HashSet<ArchivePath>();
        this.filter(remove, this.getArchive().get(ArchivePaths.root()), dependencyManager);
        for (ArchivePath each : remove) {
            this.getArchive().delete(each);
        }
    }

    protected void filter(Set<ArchivePath> remove, Node node, DependencyManager dependencyManager) {
        String path = node.getPath().get();
        if (path.startsWith("/WEB-INF/lib") && path.endsWith(".jar") && dependencyManager.isRemovable(node)) {
            remove.add(node.getPath());
        }
        for (Node each : node.getChildren()) {
            this.filter(remove, each, dependencyManager);
        }
    }
}

