/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.env.DependencyResolution;

public class SystemDependencyResolution
implements DependencyResolution {
    private static final String JAR = ".jar";
    private static final String JRE = "jre";
    final List<String> classpath;
    final String javaHome;
    final String pwd;
    final List<String> testClasspath;

    public SystemDependencyResolution() {
        String classpathProp = System.getProperty("java.class.path");
        String javaHomProp = System.getProperty("java.home");
        String userDirProp = System.getProperty("user.dir");
        String testClasspatProp = System.getProperty("swarm.test.dependencies");
        this.classpath = Arrays.asList(classpathProp.split(File.pathSeparator));
        this.testClasspath = testClasspatProp != null ? Arrays.asList(testClasspatProp.split(File.pathSeparator)) : Collections.EMPTY_LIST;
        this.pwd = userDirProp;
        this.javaHome = javaHomProp.endsWith(JRE) ? javaHomProp.substring(0, javaHomProp.lastIndexOf(JRE)) : javaHomProp;
    }

    @Override
    public Set<String> resolve(List<String> exclusions) throws IOException {
        HashSet<String> archivesPaths = new HashSet<String>();
        exclusions.replaceAll(s -> s.replace('.', File.separatorChar));
        if (this.classpath != null) {
            ApplicationEnvironment env = ApplicationEnvironment.get();
            HashSet<String> classpathElements = new HashSet<String>();
            HashSet<String> providedGAVs = new HashSet<String>();
            List<String> testClasspathElements = this.testClasspath != null ? this.testClasspath : Collections.EMPTY_LIST;
            for (String element : this.classpath) {
                if (element.startsWith(this.javaHome) || element.startsWith(this.pwd + File.separatorChar) || element.endsWith(".pom") || this.excluded(exclusions, element)) continue;
                classpathElements.add(element);
            }
            providedGAVs.addAll(env.getRemovableDependencies().stream().map(e -> e.split(":")).map(e -> e[0] + File.separatorChar + e[1]).map(m -> m.replace('.', File.separatorChar)).collect(Collectors.toList()));
            for (String element : classpathElements) {
                boolean excludedByProvidedGAVs = this.excluded(providedGAVs, element);
                boolean excludedByTestClasspath = this.excluded(testClasspathElements, element);
                if (excludedByProvidedGAVs || excludedByTestClasspath) continue;
                archivesPaths.add(element);
            }
        }
        return archivesPaths;
    }
}

