/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm10;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm10.NamedQuery;
import org.jboss.shrinkwrap.descriptor.api.orm10.QueryHint;
import org.jboss.shrinkwrap.descriptor.impl.orm10.QueryHintImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamedQueryImpl<T>
implements Child<T>,
NamedQuery<T> {
    private T t;
    private Node childNode;

    public NamedQueryImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public NamedQueryImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    @Override
    public T up() {
        return this.t;
    }

    @Override
    public NamedQuery<T> query(String query) {
        this.childNode.getOrCreate("query").text(query);
        return this;
    }

    @Override
    public String getQuery() {
        return this.childNode.getTextValueForPatternName("query");
    }

    @Override
    public NamedQuery<T> removeQuery() {
        this.childNode.removeChildren("query");
        return this;
    }

    @Override
    public QueryHint<NamedQuery<T>> getOrCreateHint() {
        List<Node> nodeList = this.childNode.get("hint");
        if (nodeList != null && nodeList.size() > 0) {
            return new QueryHintImpl<NamedQuery<T>>(this, "hint", this.childNode, nodeList.get(0));
        }
        return this.createHint();
    }

    @Override
    public QueryHint<NamedQuery<T>> createHint() {
        return new QueryHintImpl<NamedQuery<T>>(this, "hint", this.childNode);
    }

    @Override
    public List<QueryHint<NamedQuery<T>>> getAllHint() {
        ArrayList<QueryHint<NamedQuery<T>>> list = new ArrayList<QueryHint<NamedQuery<T>>>();
        List<Node> nodeList = this.childNode.get("hint");
        for (Node node : nodeList) {
            QueryHintImpl<NamedQueryImpl> type = new QueryHintImpl<NamedQueryImpl>(this, "hint", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    @Override
    public NamedQuery<T> removeAllHint() {
        this.childNode.removeChildren("hint");
        return this;
    }

    @Override
    public NamedQuery<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    @Override
    public String getName() {
        return this.childNode.getAttribute("name");
    }

    @Override
    public NamedQuery<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }
}

