/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.swarm.bootstrap.env.DependencyTree;
import org.wildfly.swarm.bootstrap.util.MavenArtifactDescriptor;
import org.wildfly.swarm.tools.ArtifactSpec;

public class DeclaredDependencies
extends DependencyTree<ArtifactSpec> {
    private HashSet<ArtifactSpec> allTransient;

    @Deprecated
    public void addExplicitDependency(ArtifactSpec artifactSpec) {
        throw new IllegalArgumentException("To be removed");
    }

    @Deprecated
    public void addTransientDependency(ArtifactSpec artifactSpec) {
        throw new IllegalArgumentException("To be removed");
    }

    public Set<ArtifactSpec> getExplicitDependencies() {
        return this.getDirectDeps();
    }

    public Set<ArtifactSpec> getTransientDependencies() {
        if (null == this.allTransient) {
            this.allTransient = new HashSet();
            for (ArtifactSpec directDep : this.getDirectDeps()) {
                this.allTransient.addAll(this.getTransientDependencies(directDep));
            }
        }
        return this.allTransient;
    }

    public Set<ArtifactSpec> getTransientDependencies(ArtifactSpec artifact) {
        return this.getTransientDeps(artifact);
    }

    public boolean isPresolved() {
        return this.getTransientDependencies().size() > 0;
    }

    public static ArtifactSpec createSpec(String gav) {
        return DeclaredDependencies.createSpec(gav, "compile");
    }

    public static ArtifactSpec createSpec(String gav, String scope) {
        try {
            MavenArtifactDescriptor maven = ArtifactSpec.fromMavenGav(gav);
            return new ArtifactSpec(scope, maven.groupId(), maven.artifactId(), maven.version(), maven.type(), null, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeTo(File file) {
        try {
            FileWriter w = new FileWriter(file);
            for (ArtifactSpec key : this.depTree.keySet()) {
                w.write(key.mavenGav());
                w.write(":\n");
                for (ArtifactSpec s : (Set)this.depTree.get(key)) {
                    w.write("  - ");
                    w.write(s.mavenGav());
                    w.write("\n");
                }
            }
            ((Writer)w).close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write dependency tree", e);
        }
    }
}

