/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm10;

import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm10.Basic;
import org.jboss.shrinkwrap.descriptor.api.orm10.Column;
import org.jboss.shrinkwrap.descriptor.api.orm10.EnumType;
import org.jboss.shrinkwrap.descriptor.api.orm10.FetchType;
import org.jboss.shrinkwrap.descriptor.api.orm10.TemporalType;
import org.jboss.shrinkwrap.descriptor.impl.base.Strings;
import org.jboss.shrinkwrap.descriptor.impl.orm10.ColumnImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicImpl<T>
implements Child<T>,
Basic<T> {
    private T t;
    private Node childNode;

    public BasicImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public BasicImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    @Override
    public T up() {
        return this.t;
    }

    @Override
    public Column<Basic<T>> getOrCreateColumn() {
        Node node = this.childNode.getOrCreate("column");
        ColumnImpl<Basic<T>> column = new ColumnImpl<Basic<T>>(this, "column", this.childNode, node);
        return column;
    }

    @Override
    public Basic<T> removeColumn() {
        this.childNode.removeChildren("column");
        return this;
    }

    @Override
    public Basic<T> lob() {
        this.childNode.getOrCreate("lob");
        return this;
    }

    @Override
    public Boolean isLob() {
        return this.childNode.getSingle("lob") != null;
    }

    @Override
    public Basic<T> removeLob() {
        this.childNode.removeChild("lob");
        return this;
    }

    @Override
    public Basic<T> temporal(TemporalType temporal) {
        this.childNode.getOrCreate("temporal").text((Object)temporal);
        return this;
    }

    @Override
    public Basic<T> temporal(String temporal) {
        this.childNode.getOrCreate("temporal").text(temporal);
        return this;
    }

    @Override
    public TemporalType getTemporal() {
        return TemporalType.getFromStringValue(this.childNode.getTextValueForPatternName("temporal"));
    }

    @Override
    public String getTemporalAsString() {
        return this.childNode.getTextValueForPatternName("temporal");
    }

    @Override
    public Basic<T> removeTemporal() {
        this.childNode.removeAttribute("temporal");
        return this;
    }

    @Override
    public Basic<T> enumerated(EnumType enumerated) {
        this.childNode.getOrCreate("enumerated").text((Object)enumerated);
        return this;
    }

    @Override
    public Basic<T> enumerated(String enumerated) {
        this.childNode.getOrCreate("enumerated").text(enumerated);
        return this;
    }

    @Override
    public EnumType getEnumerated() {
        return EnumType.getFromStringValue(this.childNode.getTextValueForPatternName("enumerated"));
    }

    @Override
    public String getEnumeratedAsString() {
        return this.childNode.getTextValueForPatternName("enumerated");
    }

    @Override
    public Basic<T> removeEnumerated() {
        this.childNode.removeAttribute("enumerated");
        return this;
    }

    @Override
    public Basic<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    @Override
    public String getName() {
        return this.childNode.getAttribute("name");
    }

    @Override
    public Basic<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }

    @Override
    public Basic<T> fetch(FetchType fetch) {
        this.childNode.attribute("fetch", (Object)fetch);
        return this;
    }

    @Override
    public Basic<T> fetch(String fetch) {
        this.childNode.attribute("fetch", fetch);
        return this;
    }

    @Override
    public FetchType getFetch() {
        return FetchType.getFromStringValue(this.childNode.getAttribute("fetch"));
    }

    @Override
    public String getFetchAsString() {
        return this.childNode.getAttribute("fetch");
    }

    @Override
    public Basic<T> removeFetch() {
        this.childNode.removeAttribute("fetch");
        return this;
    }

    @Override
    public Basic<T> optional(Boolean optional) {
        this.childNode.attribute("optional", optional);
        return this;
    }

    @Override
    public Boolean isOptional() {
        return Strings.isTrue(this.childNode.getAttribute("optional"));
    }

    @Override
    public Basic<T> removeOptional() {
        this.childNode.removeAttribute("optional");
        return this;
    }
}

