/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm21;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm21.ForeignKey;
import org.jboss.shrinkwrap.descriptor.api.orm21.Index;
import org.jboss.shrinkwrap.descriptor.api.orm21.JoinColumn;
import org.jboss.shrinkwrap.descriptor.api.orm21.JoinTable;
import org.jboss.shrinkwrap.descriptor.api.orm21.UniqueConstraint;
import org.jboss.shrinkwrap.descriptor.impl.orm21.ForeignKeyImpl;
import org.jboss.shrinkwrap.descriptor.impl.orm21.IndexImpl;
import org.jboss.shrinkwrap.descriptor.impl.orm21.JoinColumnImpl;
import org.jboss.shrinkwrap.descriptor.impl.orm21.UniqueConstraintImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinTableImpl<T>
implements Child<T>,
JoinTable<T> {
    private T t;
    private Node childNode;

    public JoinTableImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public JoinTableImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    @Override
    public T up() {
        return this.t;
    }

    @Override
    public JoinColumn<JoinTable<T>> getOrCreateJoinColumn() {
        List<Node> nodeList = this.childNode.get("join-column");
        if (nodeList != null && nodeList.size() > 0) {
            return new JoinColumnImpl<JoinTable<T>>(this, "join-column", this.childNode, nodeList.get(0));
        }
        return this.createJoinColumn();
    }

    @Override
    public JoinColumn<JoinTable<T>> createJoinColumn() {
        return new JoinColumnImpl<JoinTable<T>>(this, "join-column", this.childNode);
    }

    @Override
    public List<JoinColumn<JoinTable<T>>> getAllJoinColumn() {
        ArrayList<JoinColumn<JoinTable<T>>> list = new ArrayList<JoinColumn<JoinTable<T>>>();
        List<Node> nodeList = this.childNode.get("join-column");
        for (Node node : nodeList) {
            JoinColumnImpl<JoinTableImpl> type = new JoinColumnImpl<JoinTableImpl>(this, "join-column", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    @Override
    public JoinTable<T> removeAllJoinColumn() {
        this.childNode.removeChildren("join-column");
        return this;
    }

    @Override
    public ForeignKey<JoinTable<T>> getOrCreateForeignKey() {
        Node node = this.childNode.getOrCreate("foreign-key");
        ForeignKeyImpl<JoinTable<T>> foreignKey = new ForeignKeyImpl<JoinTable<T>>(this, "foreign-key", this.childNode, node);
        return foreignKey;
    }

    @Override
    public JoinTable<T> removeForeignKey() {
        this.childNode.removeChildren("foreign-key");
        return this;
    }

    @Override
    public JoinColumn<JoinTable<T>> getOrCreateInverseJoinColumn() {
        List<Node> nodeList = this.childNode.get("inverse-join-column");
        if (nodeList != null && nodeList.size() > 0) {
            return new JoinColumnImpl<JoinTable<T>>(this, "inverse-join-column", this.childNode, nodeList.get(0));
        }
        return this.createInverseJoinColumn();
    }

    @Override
    public JoinColumn<JoinTable<T>> createInverseJoinColumn() {
        return new JoinColumnImpl<JoinTable<T>>(this, "inverse-join-column", this.childNode);
    }

    @Override
    public List<JoinColumn<JoinTable<T>>> getAllInverseJoinColumn() {
        ArrayList<JoinColumn<JoinTable<T>>> list = new ArrayList<JoinColumn<JoinTable<T>>>();
        List<Node> nodeList = this.childNode.get("inverse-join-column");
        for (Node node : nodeList) {
            JoinColumnImpl<JoinTableImpl> type = new JoinColumnImpl<JoinTableImpl>(this, "inverse-join-column", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    @Override
    public JoinTable<T> removeAllInverseJoinColumn() {
        this.childNode.removeChildren("inverse-join-column");
        return this;
    }

    @Override
    public ForeignKey<JoinTable<T>> getOrCreateInverseForeignKey() {
        Node node = this.childNode.getOrCreate("inverse-foreign-key");
        ForeignKeyImpl<JoinTable<T>> inverseForeignKey = new ForeignKeyImpl<JoinTable<T>>(this, "inverse-foreign-key", this.childNode, node);
        return inverseForeignKey;
    }

    @Override
    public JoinTable<T> removeInverseForeignKey() {
        this.childNode.removeChildren("inverse-foreign-key");
        return this;
    }

    @Override
    public UniqueConstraint<JoinTable<T>> getOrCreateUniqueConstraint() {
        List<Node> nodeList = this.childNode.get("unique-constraint");
        if (nodeList != null && nodeList.size() > 0) {
            return new UniqueConstraintImpl<JoinTable<T>>(this, "unique-constraint", this.childNode, nodeList.get(0));
        }
        return this.createUniqueConstraint();
    }

    @Override
    public UniqueConstraint<JoinTable<T>> createUniqueConstraint() {
        return new UniqueConstraintImpl<JoinTable<T>>(this, "unique-constraint", this.childNode);
    }

    @Override
    public List<UniqueConstraint<JoinTable<T>>> getAllUniqueConstraint() {
        ArrayList<UniqueConstraint<JoinTable<T>>> list = new ArrayList<UniqueConstraint<JoinTable<T>>>();
        List<Node> nodeList = this.childNode.get("unique-constraint");
        for (Node node : nodeList) {
            UniqueConstraintImpl<JoinTableImpl> type = new UniqueConstraintImpl<JoinTableImpl>(this, "unique-constraint", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    @Override
    public JoinTable<T> removeAllUniqueConstraint() {
        this.childNode.removeChildren("unique-constraint");
        return this;
    }

    @Override
    public Index<JoinTable<T>> getOrCreateIndex() {
        List<Node> nodeList = this.childNode.get("index");
        if (nodeList != null && nodeList.size() > 0) {
            return new IndexImpl<JoinTable<T>>(this, "index", this.childNode, nodeList.get(0));
        }
        return this.createIndex();
    }

    @Override
    public Index<JoinTable<T>> createIndex() {
        return new IndexImpl<JoinTable<T>>(this, "index", this.childNode);
    }

    @Override
    public List<Index<JoinTable<T>>> getAllIndex() {
        ArrayList<Index<JoinTable<T>>> list = new ArrayList<Index<JoinTable<T>>>();
        List<Node> nodeList = this.childNode.get("index");
        for (Node node : nodeList) {
            IndexImpl<JoinTableImpl> type = new IndexImpl<JoinTableImpl>(this, "index", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    @Override
    public JoinTable<T> removeAllIndex() {
        this.childNode.removeChildren("index");
        return this;
    }

    @Override
    public JoinTable<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    @Override
    public String getName() {
        return this.childNode.getAttribute("name");
    }

    @Override
    public JoinTable<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }

    @Override
    public JoinTable<T> catalog(String catalog) {
        this.childNode.attribute("catalog", catalog);
        return this;
    }

    @Override
    public String getCatalog() {
        return this.childNode.getAttribute("catalog");
    }

    @Override
    public JoinTable<T> removeCatalog() {
        this.childNode.removeAttribute("catalog");
        return this;
    }

    @Override
    public JoinTable<T> schema(String schema) {
        this.childNode.attribute("schema", schema);
        return this;
    }

    @Override
    public String getSchema() {
        return this.childNode.getAttribute("schema");
    }

    @Override
    public JoinTable<T> removeSchema() {
        this.childNode.removeAttribute("schema");
        return this;
    }
}

