/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.arquillian.resolver;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.PomlessResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenChecksumPolicy;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepositories;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenRemoteRepository;
import org.jboss.shrinkwrap.resolver.api.maven.repository.MavenUpdatePolicy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.NonTransitiveStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.ConfigurableMavenWorkingSessionImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.wildfly.swarm.arquillian.resolver.CompletableTransferListener;
import org.wildfly.swarm.arquillian.resolver.FailureReportingTransferListener;
import org.wildfly.swarm.arquillian.resolver.SimpleRepositoryCache;
import org.wildfly.swarm.tools.ArtifactResolvingHelper;
import org.wildfly.swarm.tools.ArtifactSpec;

public class ShrinkwrapArtifactResolvingHelper
implements ArtifactResolvingHelper {
    private static AtomicReference<ShrinkwrapArtifactResolvingHelper> INSTANCE = new AtomicReference();
    private final ConfigurableMavenResolverSystem resolver;
    private CompletableTransferListener transferListener;
    private RepositoryListener repositoryListener;

    public static ShrinkwrapArtifactResolvingHelper defaultInstance() {
        return INSTANCE.updateAndGet(e -> {
            if (e != null) {
                return e;
            }
            MavenRemoteRepository jbossPublic = MavenRemoteRepositories.createRemoteRepository("jboss-public-repository-group", "http://repository.jboss.org/nexus/content/groups/public/", "default");
            jbossPublic.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
            jbossPublic.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
            MavenRemoteRepository gradleTools = MavenRemoteRepositories.createRemoteRepository("gradle", "http://repo.gradle.org/gradle/libs-releases-local", "default");
            gradleTools.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
            gradleTools.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
            Boolean offline = Boolean.valueOf(System.getProperty("swarm.resolver.offline", "false"));
            ConfigurableMavenResolverSystem resolver = (ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)((ConfigurableMavenResolverSystem)Maven.configureResolver().withMavenCentralRepo(true)).withRemoteRepo(jbossPublic)).withRemoteRepo(gradleTools)).workOffline(offline);
            String additionalRepos = System.getProperty("swarm.build.repos");
            if (additionalRepos != null) {
                Arrays.asList(additionalRepos.split(",")).forEach(r -> {
                    MavenRemoteRepository repo = MavenRemoteRepositories.createRemoteRepository(r, r, "default");
                    repo.setChecksumPolicy(MavenChecksumPolicy.CHECKSUM_POLICY_IGNORE);
                    repo.setUpdatePolicy(MavenUpdatePolicy.UPDATE_POLICY_NEVER);
                    resolver.withRemoteRepo(repo);
                });
            }
            ShrinkwrapArtifactResolvingHelper helper = new ShrinkwrapArtifactResolvingHelper(resolver);
            helper.session().setCache(new SimpleRepositoryCache());
            helper.session().setUpdatePolicy("daily");
            helper.session().setChecksumPolicy("ignore");
            return helper;
        });
    }

    public ConfigurableMavenResolverSystem getResolver() {
        return this.resolver;
    }

    public ShrinkwrapArtifactResolvingHelper(ConfigurableMavenResolverSystem resolver) {
        this.resolver = resolver;
        this.transferListener(new FailureReportingTransferListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArtifactSpec resolve(ArtifactSpec spec) {
        if (spec.file == null) {
            File localFile = new File(this.settings().getLocalRepository(), spec.jarRepoPath());
            if (localFile.exists()) {
                spec.file = localFile;
            } else {
                this.resetListeners();
                try {
                    File file = ((MavenFormatStage)((MavenStrategyStage)this.resolver.resolve(spec.mavenGav())).withoutTransitivity()).asSingleFile();
                    if (file != null) {
                        spec.file = file;
                    }
                }
                finally {
                    this.resolutionComplete();
                }
            }
        }
        return spec.file != null ? spec : null;
    }

    @Override
    public Set<ArtifactSpec> resolveAll(Collection<ArtifactSpec> specs, boolean transitive, boolean defaultExcludes) {
        if (specs.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Enum transitivityStrategy = transitive ? TransitiveStrategy.INSTANCE : NonTransitiveStrategy.INSTANCE;
        this.resetListeners();
        MavenResolvedArtifact[] artifacts = this.withResolver(arg_0 -> this.lambda$resolveAll$3(specs, (MavenResolutionStrategy)((Object)transitivityStrategy), arg_0));
        return Arrays.stream(artifacts).map(artifact -> {
            MavenCoordinate coord = artifact.getCoordinate();
            return new ArtifactSpec(artifact.getScope().toString(), coord.getGroupId(), coord.getArtifactId(), coord.getVersion(), coord.getPackaging().getId(), coord.getClassifier(), artifact.asFile());
        }).collect(Collectors.toSet());
    }

    public MavenDependency createMavenDependency(ArtifactSpec spec) {
        MavenCoordinate newCoordinate = MavenCoordinates.createCoordinate(spec.groupId(), spec.artifactId(), spec.version(), PackagingType.of(spec.type()), spec.classifier());
        return MavenDependencies.createDependency(newCoordinate, ScopeType.fromScopeType(spec.scope), false, new MavenDependencyExclusion[0]);
    }

    public ShrinkwrapArtifactResolvingHelper repositoryListener(RepositoryListener l) {
        this.repositoryListener = l;
        return this;
    }

    public ShrinkwrapArtifactResolvingHelper transferListener(CompletableTransferListener l) {
        this.transferListener = l;
        return this;
    }

    public MavenResolvedArtifact[] withResolver(ResolverAction action) {
        this.resetListeners();
        try {
            MavenResolvedArtifact[] mavenResolvedArtifactArray = action.resolve(this.resolver);
            return mavenResolvedArtifactArray;
        }
        finally {
            this.resolutionComplete();
        }
    }

    private void resetListeners() {
        DefaultRepositorySystemSession session = this.session();
        session.setRepositoryListener(this.repositoryListener);
        session.setTransferListener(this.transferListener);
    }

    private void resolutionComplete() {
        if (this.transferListener != null) {
            this.transferListener.complete();
        }
    }

    private DefaultRepositorySystemSession session() {
        return (DefaultRepositorySystemSession)this.invokeWorkingSessionMethod("getSession");
    }

    private Settings settings() {
        return (Settings)this.invokeWorkingSessionMethod("getSettings");
    }

    private Object invokeWorkingSessionMethod(String methodName) {
        try {
            Method method = ConfigurableMavenWorkingSessionImpl.class.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method.invoke((Object)((MavenWorkingSessionContainer)((Object)this.resolver)).getMavenWorkingSession(), new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke " + methodName, e);
        }
    }

    private /* synthetic */ MavenResolvedArtifact[] lambda$resolveAll$3(Collection specs, MavenResolutionStrategy transitivityStrategy, ConfigurableMavenResolverSystem r) {
        specs.forEach(spec -> {
            PomlessResolveStage cfr_ignored_0 = (PomlessResolveStage)r.addDependency(this.createMavenDependency((ArtifactSpec)spec));
        });
        return ((MavenFormatStage)((MavenStrategyStage)r.resolve()).using(transitivityStrategy)).as(MavenResolvedArtifact.class);
    }

    public static interface ResolverAction {
        public MavenResolvedArtifact[] resolve(ConfigurableMavenResolverSystem var1);
    }
}

