/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DependencyTree<T> {
    protected Map<T, Set<T>> depTree = new HashMap<T, Set<T>>();

    public void add(T parent, T child) {
        if (!this.depTree.keySet().contains(parent)) {
            this.depTree.put(parent, new HashSet());
        }
        if (!child.equals(parent)) {
            this.depTree.get(parent).add(child);
        }
    }

    public void add(T parent) {
        if (!this.depTree.keySet().contains(parent)) {
            this.depTree.put(parent, new HashSet());
        }
    }

    public Collection<T> getDirectDeps() {
        return this.depTree.keySet().stream().sorted(this::comparator).collect(Collectors.toList());
    }

    protected int comparator(T first, T second) {
        return 0;
    }

    public Collection<T> getTransientDeps(T parent) {
        Set<T> deps = this.depTree.get(parent);
        if (null == deps) {
            throw new IllegalArgumentException("Unknown dependency " + parent);
        }
        return deps;
    }
}

