/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.xml.ModuleXmlParser;
import org.wildfly.swarm.bootstrap.env.ApplicationEnvironment;
import org.wildfly.swarm.bootstrap.logging.BootstrapLogger;
import org.wildfly.swarm.bootstrap.modules.MavenResolvers;
import org.wildfly.swarm.bootstrap.modules.NestedJarResourceLoader;

public class ClasspathModuleFinder
implements ModuleFinder {
    private static final char MODULE_SEPARATOR = '/';
    private static final BootstrapLogger LOG = BootstrapLogger.logger("org.wildfly.swarm.modules.classpath");

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ModuleSpec findModule(ModuleIdentifier identifier, ModuleLoader delegateLoader) throws ModuleLoadException {
        String path = "modules/" + identifier.getName().replace('.', '/') + '/' + identifier.getSlot() + "/module.xml";
        if (LOG.isTraceEnabled()) {
            LOG.trace("attempt:" + identifier);
        }
        try {
            URL url;
            ClassLoader cl = ApplicationEnvironment.get().getBootstrapClassLoader();
            if (LOG.isTraceEnabled()) {
                LOG.trace("classloader: " + cl);
                LOG.trace("path: " + path);
            }
            if ((url = cl.getResource(path)) == null && cl != ClasspathModuleFinder.class.getClassLoader()) {
                url = ClasspathModuleFinder.class.getClassLoader().getResource(path);
            }
            if (url == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("not found: " + identifier);
                }
                return null;
            }
            URL base = new URL(url, "./");
            if (LOG.isTraceEnabled()) {
                LOG.trace("base of " + identifier + ": " + base);
            }
            InputStream in = url.openStream();
            ModuleSpec moduleSpec = null;
            try {
                moduleSpec = ModuleXmlParser.parseModuleXml((rootPath, loaderPath, loaderName) -> NestedJarResourceLoader.loaderFor(base, rootPath, loaderPath, loaderName), MavenResolvers.get(), "/", in, path.toString(), delegateLoader, identifier);
            }
            catch (IOException e) {
                throw new ModuleLoadException(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new ModuleLoadException(e);
                }
            }
            return moduleSpec;
        }
        catch (IOException e) {
            throw new ModuleLoadException(e);
        }
    }
}

